package eu.dnetlib.data.oai.store.actions;

import java.util.concurrent.Callable;

import javax.annotation.Resource;

import eu.dnetlib.data.oai.store.conf.OAISetHelper;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class RefreshConfigAction extends AbstractOAIStoreAction {

	@Resource
	private OAISetHelper oaiSetHelper;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
		this.oaiSetHelper.updateSetsFromConfig(new Callable<Object>() {

			@Override
			public Object call() {
				handler.done(job);
				return null;
			}
		}, new Callable<Object>() {

			@Override
			public Object call() {
				handler.failed(job, new Exception("Error during OAI sets update from configuration"));
				return null;
			}
		});

	}

	public OAISetHelper getOaiSetHelper() {
		return oaiSetHelper;
	}

	public void setOaiSetHelper(final OAISetHelper oaiSetHelper) {
		this.oaiSetHelper = oaiSetHelper;
	}

}
