package eu.dnetlib.data.oai.store.conf;

import javax.annotation.Resource;

import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationStringReader;
import eu.dnetlib.data.oai.store.sets.MongoSetCollection;
import eu.dnetlib.enabling.actions.AbstractSubscriptionAction;

/**
 * When notified, it updates the OAI sets configured via the IS profile.
 * 
 * @author alessia
 * 
 */
public class OAISetNotificationHandler extends AbstractSubscriptionAction {

	@Resource
	private OAIConfigurationStringReader configurationReader;
	@Resource
	private MongoSetCollection mongoSetCollection;
	@Resource
	private OAISetHelper oaiSetHelper;

	/**
	 * 
	 * {@inheritDoc}
	 * 
	 * @see eu.dnetlib.enabling.tools.blackboard.NotificationHandler#notified(java.lang.String, java.lang.String, java.lang.String,
	 *      java.lang.String)
	 */
	@Override
	public void notified(final String subscrId, final String topic, final String rsId, final String profile) {
		if (!topic.startsWith(getTopicPrefix()) || !isEnabled()) return;
		this.configurationReader.readConfiguration(profile);
		new Thread() {

			@Override
			public void run() {
				oaiSetHelper.updateSetsFromConfig(configurationReader);
			}

		}.start();
	}

	public OAIConfigurationStringReader getConfigurationReader() {
		return configurationReader;
	}

	public void setConfigurationReader(final OAIConfigurationStringReader configurationReader) {
		this.configurationReader = configurationReader;
	}

	public MongoSetCollection getMongoSetCollection() {
		return mongoSetCollection;
	}

	public void setMongoSetCollection(final MongoSetCollection mongoSetCollection) {
		this.mongoSetCollection = mongoSetCollection;
	}

	public OAISetHelper getOaiSetHelper() {
		return oaiSetHelper;
	}

	public void setOaiSetHelper(final OAISetHelper oaiSetHelper) {
		this.oaiSetHelper = oaiSetHelper;
	}

}
