package eu.dnetlib.data.oai.store.sync;

import java.util.concurrent.Callable;

import javax.annotation.Resource;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import eu.dnetlib.data.information.oai.publisher.OaiPublisherException;
import eu.dnetlib.data.information.oai.publisher.OaiPublisherRuntimeException;
import eu.dnetlib.data.information.oai.publisher.conf.OAIConfigurationExistReader;
import eu.dnetlib.data.information.oai.publisher.info.MDFInfo;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStore;
import eu.dnetlib.data.oai.store.mongo.MongoPublisherStoreDAO;

public class OAIStoreSynchronizer {

	private static final Log log = LogFactory.getLog(OAIStoreSynchronizer.class); // NOPMD by marko on 11/24/08 5:02 PM
	/**
	 * OAI Publisher configuration.
	 */
	@Resource
	private OAIConfigurationExistReader configuration;
	@Resource
	private MongoPublisherStoreDAO publisherStoreDAO;

	// @Resource
	// private OAIStoreInitializerFactory initializerFactory;

	// /**
	// * Number of threads to use in the pool for the synchronization.
	// */
	// private int maxInitThreads = 2;

	public void synchronize(final Iterable<String> records,
			final MDFInfo sourceMetadataFormat,
			final String recordSource,
			final Callable<?> callback,
			final Callable<?> failCallback) {
		try {
			log.fatal("Synchronizing content for source metadata format " + sourceMetadataFormat);
			MongoPublisherStore store = this.getStore(sourceMetadataFormat);
			int count = store.feed(records, recordSource);
			log.info("Content synchronized: store " + sourceMetadataFormat + " fed with " + count + " records");
			executeCallback(callback);
		} catch (Exception e) {
			log.error(e);
			executeCallback(failCallback);
		}

		// log.info("Initializing OAI Publisher stores from its configuration profile with initializer from factory: "
		// + initializerFactory.getClass().getCanonicalName());
		// new Thread() {
		//
		// @Override
		// public void run() {
		// try {
		// checkStores();
		// } catch (InterruptedException e) {
		// log.error(e);
		// executeCallback(failCallback);
		// } catch (ExecutionException e) {
		// log.error(e);
		// executeCallback(failCallback);
		// }
		// log.info("OAI Publisher configuration updated.");
		// executeCallback(callback);
		// }
		//
		// }.start();
	}

	/**
	 * Gets the OAI store for the given source metadata format. If the store does not exists, then a new one is created.
	 * 
	 * @param sourceMetadataFormat
	 *            MDFInfo about the metadata format of the store to get
	 * @return a MongoPublisherStore instance
	 */
	private MongoPublisherStore getStore(final MDFInfo sourceMetadataFormat) {
		MongoPublisherStore store = this.publisherStoreDAO.getStore(sourceMetadataFormat.getSourceFormatName(),
				sourceMetadataFormat.getSourceFormatInterpretation(), sourceMetadataFormat.getSourceFormatLayout());
		if (store == null) {
			log.debug("Creating store for metadata format: \n" + sourceMetadataFormat);
			try {
				store = this.publisherStoreDAO.createStore(sourceMetadataFormat.getSourceFormatName(), sourceMetadataFormat.getSourceFormatInterpretation(),
						sourceMetadataFormat.getSourceFormatLayout());
				log.debug("Created store with id: " + store.getId());
			} catch (OaiPublisherException e) {
				throw new OaiPublisherRuntimeException(e);
			}
		}
		return store;
	}

	// protected void checkStores() throws InterruptedException, ExecutionException {
	// final ExecutorService executor = Executors.newFixedThreadPool(maxInitThreads);
	// List<MDFInfo> metadataFormats = this.configuration.getSourceMetadataFormats();
	// List<Future<?>> futures = Lists.newArrayList();
	// for (MDFInfo mdf : metadataFormats) {
	// futures.add(executor.submit(initializerFactory.create(mdf)));
	// }
	// executor.shutdown();
	// for (Future<?> future : futures) {
	// future.get();
	// }
	// }

	protected void executeCallback(final Callable<?> callback) {
		if (callback != null) {
			try {
				callback.call();
			} catch (Exception e) {
				log.error("Error executing callback", e);
			}
		}
	}

	public OAIConfigurationExistReader getConfiguration() {
		return configuration;
	}

	public void setConfiguration(final OAIConfigurationExistReader configuration) {
		this.configuration = configuration;
	}

	// public OAIStoreInitializerFactory getInitializerFactory() {
	// return initializerFactory;
	// }
	//
	// public void setInitializerFactory(final OAIStoreInitializerFactory initializerFactory) {
	// this.initializerFactory = initializerFactory;
	// }

	// public int getMaxInitThreads() {
	// return maxInitThreads;
	// }
	//
	// public void setMaxInitThreads(final int maxInitThreads) {
	// this.maxInitThreads = maxInitThreads;
	// }

	public MongoPublisherStoreDAO getPublisherStoreDAO() {
		return publisherStoreDAO;
	}

	public void setPublisherStoreDAO(final MongoPublisherStoreDAO publisherStoreDAO) {
		this.publisherStoreDAO = publisherStoreDAO;
	}

}
