/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.clustering;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.pace.clustering.ClusteringCombiner;
import eu.dnetlib.pace.clustering.FieldFilter;
import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.MapDocument;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BlacklistAwareClusteringCombiner
extends ClusteringCombiner {
    public static Collection<String> filterAndCombine(MapDocument a, Config conf, Map<String, Set<String>> blacklists) {
        MapDocument filtered = new BlacklistAwareClusteringCombiner().filter(a, blacklists);
        return BlacklistAwareClusteringCombiner.combine(filtered, conf);
    }

    private MapDocument filter(MapDocument a, Map<String, Set<String>> blacklists) {
        HashMap filtered = Maps.newHashMap(a.getFieldMap());
        if (blacklists != null) {
            for (Map.Entry e : filtered.entrySet()) {
                filtered.put(e.getKey(), Lists.newArrayList((Iterable)Iterables.filter((Iterable)((Iterable)e.getValue()), (Predicate)new FieldFilter((String)e.getKey(), blacklists))));
            }
        }
        return new MapDocument(a.getIdentifier(), filtered);
    }

    protected boolean regexMatches(String fieldName, String value, Map<String, Set<String>> blacklists) {
        if (blacklists.containsKey(fieldName)) {
            for (String regex : blacklists.get(fieldName)) {
                if (!value.matches(regex)) continue;
                return true;
            }
        }
        return false;
    }
}

