/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.clustering;

import com.google.common.base.Predicate;
import eu.dnetlib.pace.model.Field;
import java.util.Map;
import java.util.Set;

public class FieldFilter
implements Predicate<Field> {
    private Map<String, Set<String>> blacklists;
    private String filedName;

    public FieldFilter(String fieldName, Map<String, Set<String>> blacklists) {
        this.filedName = fieldName;
        this.blacklists = blacklists;
    }

    public boolean apply(Field f) {
        return !this.regexMatches(this.filedName, f.stringValue(), this.blacklists);
    }

    protected boolean regexMatches(String fieldName, String value, Map<String, Set<String>> blacklists) {
        if (blacklists.containsKey(fieldName)) {
            for (String regex : blacklists.get(fieldName)) {
                if (!value.matches(regex)) continue;
                return true;
            }
        }
        return false;
    }
}

