/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.condition;

import eu.dnetlib.pace.condition.AbstractCondition;
import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class YearMatch
extends AbstractCondition {
    private int limit = 4;

    public YearMatch(List<String> fields) {
        super(fields);
    }

    @Override
    public boolean verify(Document a, Document b) {
        boolean res = true;
        for (String field : this.fields) {
            String valueA = this.getNumbers(this.getValue(a.values(field)));
            String valueB = this.getNumbers(this.getValue(b.values(field)));
            boolean lengthMatch = this.checkLength(valueA) && this.checkLength(valueB);
            boolean onemissing = valueA.isEmpty() || valueB.isEmpty();
            res = res && lengthMatch && valueA.equals(valueB) || onemissing;
        }
        return res;
    }

    protected boolean checkLength(String s) {
        return s.length() == this.limit;
    }

    private String getValue(List<Field> values) {
        return values != null && !values.isEmpty() ? StringUtils.left((String)values.get(0).getValue().toString(), (int)this.limit) : null;
    }
}

