/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.config;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import eu.dnetlib.pace.clustering.Acronyms;
import eu.dnetlib.pace.clustering.Clustering;
import eu.dnetlib.pace.clustering.ClusteringFunction;
import eu.dnetlib.pace.clustering.NgramPairs;
import eu.dnetlib.pace.clustering.Ngrams;
import eu.dnetlib.pace.clustering.RandomClusteringFunction;
import eu.dnetlib.pace.clustering.SuffixPrefix;
import eu.dnetlib.pace.common.AbstractPaceFunctions;
import eu.dnetlib.pace.condition.AlwaysTrueCondition;
import eu.dnetlib.pace.condition.ConditionAlgo;
import eu.dnetlib.pace.condition.TitleVersionMatch;
import eu.dnetlib.pace.condition.YearMatch;
import eu.dnetlib.pace.config.Algo;
import eu.dnetlib.pace.config.Cond;
import eu.dnetlib.pace.config.OverrideConfig;
import eu.dnetlib.pace.distance.DistanceAlgo;
import eu.dnetlib.pace.distance.JaroWinkler;
import eu.dnetlib.pace.distance.JaroWinklerTitle;
import eu.dnetlib.pace.distance.Level2JaroWinkler;
import eu.dnetlib.pace.distance.Level2Levenstein;
import eu.dnetlib.pace.distance.Levenstein;
import eu.dnetlib.pace.distance.NullDistanceAlgo;
import eu.dnetlib.pace.distance.SubStringLevenstein;
import eu.dnetlib.pace.distance.YearLevenstein;
import eu.dnetlib.pace.model.ClusteringDef;
import eu.dnetlib.pace.model.CondDef;
import eu.dnetlib.pace.model.FieldDef;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ConfigurableModel
extends OverrideConfig {
    private Predicate<String> filterStrict = new Predicate<String>(){

        public boolean apply(String key) {
            return !key.equals("strict");
        }
    };

    @Override
    public List<FieldDef> fields() {
        return this.parseFields("");
    }

    @Override
    public List<CondDef> conditions() {
        return this.parseConds("");
    }

    @Override
    public List<ClusteringDef> clusterings() {
        return this.parseClustering("");
    }

    @Override
    public Map<String, Set<String>> blacklists() {
        return this.parseBlacklists();
    }

    @Override
    public List<FieldDef> strictFields() {
        return this.parseFields(".strict");
    }

    @Override
    public FieldDef identifierFieldDef() {
        return new FieldDef(this.identifierField(), new NullDistanceAlgo(), false);
    }

    private List<FieldDef> parseFields(final String base) {
        Map modelMap = (Map)this.config.getObject("pace.conf.model");
        return Lists.newArrayList((Iterable)Iterables.transform(this.filter(modelMap).entrySet(), (Function)new Function<Map.Entry<String, ?>, FieldDef>(){

            public FieldDef apply(Map.Entry<String, ?> e) {
                String name = e.getKey();
                double weight = ConfigurableModel.this.config.getDouble(String.format("pace.conf.model%s.%s.weight", base, name));
                boolean ignoreMissing = ConfigurableModel.this.config.getBoolean(String.format("pace.conf.model%s.%s.ignoreMissing", base, name));
                return new FieldDef(name, this.getAlgo(base, name, weight), ignoreMissing);
            }

            private DistanceAlgo getAlgo(String base2, String name, double w) {
                switch (Algo.valueOf(ConfigurableModel.this.config.getString(String.format("pace.conf.model%s.%s.algo", base2, name)))) {
                    case JaroWinkler: {
                        return new JaroWinkler(w);
                    }
                    case JaroWinklerTitle: {
                        return new JaroWinklerTitle(w);
                    }
                    case Level2JaroWinkler: {
                        return new Level2JaroWinkler(w);
                    }
                    case Level2Levenstein: {
                        return new Level2Levenstein(w);
                    }
                    case Levenstein: {
                        return new Levenstein(w);
                    }
                    case SubStringLevenstein: {
                        return new SubStringLevenstein(w, ConfigurableModel.this.config.getInt(String.format("pace.conf.model%s.%s.limit", base2, name)));
                    }
                    case YearLevenstein: {
                        return new YearLevenstein(w, ConfigurableModel.this.config.getInt(String.format("pace.conf.model%s.%s.limit", base2, name)));
                    }
                    case Null: {
                        return new NullDistanceAlgo();
                    }
                }
                return new NullDistanceAlgo();
            }
        }));
    }

    public List<CondDef> parseConds(final String base) {
        Map modelMap = (Map)this.config.getObject("pace.conf.conditions");
        return Lists.newArrayList((Iterable)Iterables.transform(this.filter(modelMap).entrySet(), (Function)new Function<Map.Entry<String, ?>, CondDef>(){

            public CondDef apply(Map.Entry<String, ?> e) {
                Cond condName = Cond.valueOf(e.getKey());
                List<String> fields = ConfigurableModel.this.config.getList(String.format("pace.conf.conditions%s.%s.fields", base, e.getKey()));
                return new CondDef(this.getCondAlgo(fields, condName));
            }

            private ConditionAlgo getCondAlgo(List<String> fields, Cond condName) {
                switch (condName) {
                    case yearMatch: {
                        return new YearMatch(fields);
                    }
                    case titleVersionMatch: {
                        return new TitleVersionMatch(fields);
                    }
                }
                return new AlwaysTrueCondition(fields);
            }
        }));
    }

    public List<ClusteringDef> parseClustering(final String base) {
        Map modelMap = (Map)this.config.getObject("pace.conf.clustering");
        return Lists.newArrayList((Iterable)Iterables.transform(this.filter(modelMap).entrySet(), (Function)new Function<Map.Entry<String, ?>, ClusteringDef>(){

            public ClusteringDef apply(Map.Entry<String, ?> e) {
                Clustering clustering = Clustering.valueOf(e.getKey());
                List<String> fields = ConfigurableModel.this.config.getList(String.format("pace.conf.clustering%s.%s.fields", base, e.getKey()));
                Map params = (Map)ConfigurableModel.this.config.getObject(String.format("pace.conf.clustering%s.%s.params", base, e.getKey()));
                return new ClusteringDef(clustering, this.getClusteringFunction(params, clustering), fields);
            }

            private ClusteringFunction getClusteringFunction(Map<String, Integer> params, Clustering clustering) {
                switch (clustering) {
                    case acronyms: {
                        return new Acronyms(params);
                    }
                    case ngrams: {
                        return new Ngrams(params);
                    }
                    case ngrampairs: {
                        return new NgramPairs(params);
                    }
                    case suffixprefix: {
                        return new SuffixPrefix(params);
                    }
                }
                return new RandomClusteringFunction(params);
            }
        }));
    }

    public Map<String, Set<String>> parseBlacklists() {
        HashMap res = Maps.newHashMap();
        for (String string : this.config.hasPath("pace.conf.blacklists") != false ? this.config.getList("pace.conf.blacklists") : new ArrayList()) {
            res.put(string, AbstractPaceFunctions.loadFromClasspath("/eu/dnetlib/pace/config/" + string + "_blacklist.txt"));
        }
        return res;
    }

    private Map<String, ?> filter(Map<String, ?> modelMap) {
        return modelMap != null ? Maps.filterKeys(modelMap, this.filterStrict) : new HashMap();
    }
}

