/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance;

import eu.dnetlib.pace.model.CondDef;
import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;
import java.util.List;

public class DistanceScorer {
    private List<FieldDef> fields;
    private List<CondDef> conds;

    public DistanceScorer(List<FieldDef> fields, List<CondDef> conds) {
        this.fields = fields;
        this.conds = conds;
    }

    public double distance(Document a, Document b) {
        double w = this.sumWeights(this.fields);
        double sum = 0.0;
        boolean c = true;
        for (CondDef cd : this.conds) {
            c = c && cd.getConditionAlgo().verify(a, b);
        }
        if (c) {
            for (FieldDef fd : this.fields) {
                double d = this.fieldDistance(a, b, fd);
                if (d > 0.0) {
                    sum += d;
                    continue;
                }
                w -= fd.getAlgo().getWeight();
            }
            return w == 0.0 ? 0.0 : sum / w;
        }
        return 0.0;
    }

    private double fieldDistance(Document a, Document b, FieldDef fd) {
        double w = fd.getAlgo().getWeight();
        if (w == 0.0) {
            return 0.0;
        }
        Field va = this.getValue(a, fd);
        Field vb = this.getValue(b, fd);
        if (va.isEmpty() || vb.isEmpty()) {
            if (fd.isIgnoreMissing()) {
                return -1.0;
            }
            return w;
        }
        if (va.getType().equals((Object)vb.getType())) {
            return w * fd.getAlgo().distance(va, vb);
        }
        throw new IllegalArgumentException("Types are differents type");
    }

    private Field getValue(Document d, FieldDef fd) {
        List<Field> fields = d.values(fd.getName());
        return fields != null && !fields.isEmpty() ? fields.get(0) : new Field();
    }

    private double sumWeights(List<FieldDef> fields) {
        double sum = 0.0;
        for (FieldDef fd : fields) {
            sum += fd.getAlgo().getWeight();
        }
        return sum;
    }
}

