/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.distance;

import com.google.common.collect.Lists;
import com.wcohen.ss.AbstractStringDistance;
import eu.dnetlib.pace.common.AbstractPaceFunctions;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.distance.DistanceAlgo;
import eu.dnetlib.pace.model.Field;
import java.util.ArrayList;
import java.util.List;

public abstract class SecondStringDistanceAlgo
extends AbstractPaceFunctions
implements DistanceAlgo {
    protected AbstractStringDistance ssalgo;
    protected double weight = 0.0;

    protected SecondStringDistanceAlgo(double weight, AbstractStringDistance ssalgo) {
        this.ssalgo = ssalgo;
        this.weight = weight;
    }

    protected abstract double normalize(double var1);

    public double distance(String a, String b) {
        return this.normalize(this.ssalgo.score(a, b));
    }

    protected double distance(List<String> a, List<String> b) {
        return this.distance(this.concat(a), this.concat(b));
    }

    @Override
    public double distance(Field a, Field b) {
        if (a.getType().equals((Object)Type.String) && b.getType().equals((Object)Type.String)) {
            return this.distance(a.getValue().toString(), b.getValue().toString());
        }
        if (a.getType().equals((Object)Type.List) && b.getType().equals((Object)Type.List)) {
            return this.distance(this.toList(a), this.toList(b));
        }
        throw new IllegalArgumentException("invalid types\n- A: " + a.toString() + "\n- B: " + b.toString());
    }

    private List<String> toList(Field list) {
        ArrayList res = Lists.newArrayList();
        for (Object f : (List)list.getValue()) {
            res.add(((Field)f).getValue().toString());
        }
        return res;
    }
}

