/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.Descriptors;
import com.google.protobuf.GeneratedMessage;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.FieldDef;
import eu.dnetlib.pace.model.MapDocument;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DocumentBuilder {
    public static MapDocument newInstance(String identifier, Map<String, List<Field>> fieldMap) {
        return new MapDocument(identifier, fieldMap);
    }

    public static MapDocument newInstance(String identifier, byte[] fieldMap) {
        return new MapDocument(identifier, fieldMap);
    }

    public static MapDocument newInstance(String id, GeneratedMessage metadata, List<FieldDef> fields) {
        return DocumentBuilder.newInstance(id, new DocumentBuilder().generateFieldMap(metadata, fields));
    }

    private Map<String, List<Field>> generateFieldMap(GeneratedMessage metadata, List<FieldDef> fields) {
        HashMap fieldMap = Maps.newHashMap();
        for (FieldDef fd : fields) {
            fieldMap.put(fd.getName(), this.processPath(fd.getName(), metadata, Arrays.asList(fd.getPath().split("/"))));
        }
        return fieldMap;
    }

    public List<Field> processPath(String name, GeneratedMessage message, List<String> list) {
        ArrayList response = Lists.newArrayList();
        if (list.isEmpty()) {
            throw new RuntimeException("ProtoBuf navigation path is empty");
        }
        Descriptors.FieldDescriptor desc = message.getDescriptorForType().findFieldByName(list.get(0));
        if (desc != null) {
            if (desc.isRepeated()) {
                int count = message.getRepeatedFieldCount(desc);
                for (int i = 0; i < count; ++i) {
                    Object field = message.getRepeatedField(desc, i);
                    response.addAll(this.generateFields(name, field, list));
                }
            } else {
                Object field = message.getField(desc);
                response.addAll(this.generateFields(name, field, list));
            }
        } else {
            throw new RuntimeException("Invalid protobuf path (field not found): " + StringUtils.join(list, (String)">"));
        }
        return response;
    }

    private List<Field> generateFields(String name, Object field, List<String> list) {
        if (field instanceof GeneratedMessage) {
            if (list.size() > 1) {
                return this.processPath(name, (GeneratedMessage)field, list.subList(1, list.size()));
            }
            throw new RuntimeException("No primitive type found");
        }
        if (list.size() == 1) {
            Type type = field instanceof Integer ? Type.Int : Type.String;
            return Lists.newArrayList((Object[])new Field[]{new Field(type, name, field)});
        }
        throw new RuntimeException("Found a primitive type before the path end");
    }
}

