/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import com.google.common.base.Joiner;
import eu.dnetlib.pace.config.Type;
import java.util.List;

public class Field {
    private Type type = Type.String;
    private String name;
    private Object value = null;

    public Field() {
    }

    public Field(Type type, String name, Object value) {
        this.type = type;
        this.name = name;
        this.value = value;
    }

    public boolean isEmpty() {
        if (this.value == null) {
            return false;
        }
        switch (this.type) {
            case String: {
                return this.value.toString().isEmpty();
            }
            case List: {
                List list = (List)this.value;
                return list.isEmpty() || ((Field)list.get(0)).isEmpty();
            }
        }
        return true;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String stringValue() {
        switch (this.getType()) {
            case Int: {
                return String.valueOf(this.getValue());
            }
            case List: {
                return Joiner.on((String)" ").join((Iterable)((List)this.getValue()));
            }
            case String: {
                return (String)this.getValue();
            }
        }
        throw new IllegalArgumentException("Unknown type: " + this.getType().toString());
    }
}

