/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.pace.model;

import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.distance.DistanceAlgo;
import eu.dnetlib.pace.model.Field;

public class FieldDef {
    public static final String PATH_SEPARATOR = "/";
    private String name;
    private DistanceAlgo algo;
    private boolean ignoreMissing;

    public FieldDef(String name, DistanceAlgo algo, boolean ignoreMissing) {
        this.name = name;
        this.algo = algo;
        this.ignoreMissing = ignoreMissing;
    }

    public Field apply(Type type, String s) {
        switch (type) {
            case Int: {
                return new Field(type, this.name, Integer.parseInt(s));
            }
            case String: {
                return new Field(type, this.name, s);
            }
        }
        throw new IllegalArgumentException("Casting not implemented for type " + (Object)((Object)type));
    }

    public String getName() {
        return this.name.split(PATH_SEPARATOR)[0];
    }

    public DistanceAlgo getAlgo() {
        return this.algo;
    }

    public boolean isIgnoreMissing() {
        return this.ignoreMissing;
    }

    public String getPath() {
        return this.name;
    }

    public String toString() {
        return this.getPath() + " { algo='" + this.getAlgo().getClass().getSimpleName() + "' weigth='" + this.getAlgo().getWeight() + "' ignoreMissing='" + this.isIgnoreMissing() + "' }";
    }
}

