/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.maven.plugin.oozie;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.StringUtils;

public class ReadJobId
extends AbstractMojo {
    public static final String PROPERTY_NAME_LOG_FILE_LOCATION = "logFileLocation";
    public static final String PROPERTY_NAME_OOZIE_JOB_ID = "oozieJobId";
    public static final String OOZIE_JOB_LOG_LINE_TOKEN_SEPARATOR = ":";
    public static final String OOZIE_JOB_LOG_LINE_PREFIX = "job:";
    private String logFileLocation;
    private MavenProject project;

    public void execute() throws MojoExecutionException, MojoFailureException {
        String extractedOozieJobId = this.extractOozieJobId(this.logFileLocation);
        if (extractedOozieJobId == null) {
            throw new MojoFailureException("unable to extract oozie job identifier from log file: " + this.logFileLocation);
        }
        this.project.getProperties().setProperty(PROPERTY_NAME_OOZIE_JOB_ID, extractedOozieJobId);
        System.out.println("extracted job identifier: " + extractedOozieJobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String extractOozieJobId(String logFileLocation) throws MojoExecutionException {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(new File(logFileLocation))));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    String[] split;
                    String trimmedLine = line.trim();
                    if (!trimmedLine.startsWith(OOZIE_JOB_LOG_LINE_PREFIX) || (split = StringUtils.split((String)trimmedLine, (String)OOZIE_JOB_LOG_LINE_TOKEN_SEPARATOR)).length != 2) continue;
                    String string = split[1].trim();
                    return string;
                }
                String string = null;
                return string;
            }
            finally {
                reader.close();
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException("unable to read log file: " + logFileLocation, (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("error occurred when reading log file: " + logFileLocation, (Exception)e);
        }
    }
}

