/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.primer;

import eu.dnetlib.iis.primer.ClassProvider;
import eu.dnetlib.iis.primer.ImportLinkFileChecker;
import eu.dnetlib.iis.primer.ImportLinkReader;
import eu.dnetlib.iis.primer.Resolver;
import eu.dnetlib.iis.primer.UnresolvableResourceException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarClassProvider
extends ClassProvider {
    private JarFile jar;

    public JarClassProvider(File jar) throws IOException {
        this.jar = new JarFile(jar);
    }

    @Override
    public List<String> getEntryNames() {
        ArrayList<String> result = new ArrayList<String>();
        Enumeration<JarEntry> entries = this.jar.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            result.add(entry.getName());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void primeOne(String classpath, File target, Resolver resolver) throws IOException, UnresolvableResourceException, ParseException {
        JarEntry entry = this.jar.getJarEntry(classpath);
        if (entry.isDirectory()) {
            FileUtils.forceMkdir((File)target);
            return;
        }
        if (ImportLinkFileChecker.checkName(new File(entry.getName())) && ImportLinkFileChecker.checkHeader(this.jar.getInputStream(entry))) {
            new ImportLinkReader(this.jar.getInputStream(entry)).performResolution(target.getParentFile(), resolver);
            return;
        }
        FileUtils.forceMkdir((File)target.getParentFile());
        FileOutputStream output = null;
        try {
            output = new FileOutputStream(target);
            InputStream input = this.jar.getInputStream(entry);
            IOUtils.copy((InputStream)input, (OutputStream)output);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)output);
    }
}

