/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.primer;

import eu.dnetlib.iis.primer.CoansysWorkflowPackageSupplier;
import eu.dnetlib.iis.primer.ResolvingService;
import eu.dnetlib.iis.primer.UnresolvableResourceException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class CoansysResolvingService
extends ResolvingService {
    private CoansysWorkflowPackageSupplier packageSupplier;

    public CoansysResolvingService(CoansysWorkflowPackageSupplier packageSupplier) {
        this.packageSupplier = packageSupplier;
    }

    @Override
    public void resolve(File target, String args) throws IOException, UnresolvableResourceException {
        String[] splits = args.split(":", 3);
        String groupId = splits[0];
        String artifactId = splits[1];
        String version = splits.length == 3 ? splits[2] : null;
        try {
            this.packageSupplier.getCoansysWorkflowPackage(groupId, artifactId, version).extract(target);
        }
        catch (FileNotFoundException ex) {
            throw new UnresolvableResourceException("Could not resolve " + args + " CoAnSys workflow package", ex);
        }
    }
}

