/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.primer;

import eu.dnetlib.iis.primer.ClassProvider;
import eu.dnetlib.iis.primer.ImportLinkFileChecker;
import eu.dnetlib.iis.primer.ImportLinkReader;
import eu.dnetlib.iis.primer.Resolver;
import eu.dnetlib.iis.primer.UnresolvableResourceException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;

public class FileSystemClassProvider
extends ClassProvider {
    private File root;

    public FileSystemClassProvider(File root) {
        this.root = root;
    }

    @Override
    public List<String> getEntryNames() {
        ArrayList<String> result = new ArrayList<String>();
        this.appendChildren("", result);
        return result;
    }

    private void appendChildren(String relativePath, List<String> result) {
        for (File f : new File(this.root, relativePath).listFiles()) {
            String beginning = StringUtils.isNotEmpty((String)relativePath) ? relativePath : "";
            String newRelativePath = beginning + f.getName();
            if (f.isDirectory()) {
                newRelativePath = newRelativePath + '/';
                this.appendChildren(newRelativePath, result);
            }
            result.add(newRelativePath);
        }
    }

    @Override
    public void primeOne(String classpath, File destination, Resolver resolver) throws IOException, UnresolvableResourceException, ParseException {
        File src = new File(this.root, classpath);
        if (src.isDirectory()) {
            FileUtils.forceMkdir((File)destination);
        } else if (ImportLinkFileChecker.checkName(src) && ImportLinkFileChecker.checkHeader(new FileInputStream(src))) {
            new ImportLinkReader(new FileInputStream(src)).performResolution(destination.getParentFile(), resolver);
        } else {
            FileUtils.copyFile((File)src, (File)destination);
        }
    }
}

