/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.primer;

import eu.dnetlib.iis.primer.CoansysWorkflowPackage;
import eu.dnetlib.iis.primer.CoansysWorkflowPackageSupplier;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import org.apache.commons.io.filefilter.WildcardFileFilter;
import org.apache.commons.lang.StringUtils;

public class FileSystemCoansysWorkflowPackageSupplier
extends CoansysWorkflowPackageSupplier {
    private File dir;
    private static String ARTIFACT_CLASSIFIER = "oozie-job";
    private static String ARTIFACT_TYPE = "tar.gz";

    public FileSystemCoansysWorkflowPackageSupplier(File dir) {
        this.dir = dir;
    }

    @Override
    public CoansysWorkflowPackage getCoansysWorkflowPackage(String groupId, String artifactId, String version) throws FileNotFoundException {
        if (StringUtils.isNotBlank((String)version)) {
            return new CoansysWorkflowPackage(this.getWorkflowPackageFile(artifactId, version));
        }
        File[] candidates = this.dir.listFiles((FileFilter)new WildcardFileFilter(this.getWorkflowPackageFileName(artifactId, "*")));
        if (candidates.length == 0) {
            throw new FileNotFoundException(String.format("Could not find CoAnSys workflow package matching pattern %s", this.getWorkflowPackageFile(artifactId, "*").getAbsolutePath()));
        }
        if (candidates.length > 1) {
            throw new FileNotFoundException(String.format("Filename pattern %s is ambiguous. Please specify CoAnSys workflow package version.", this.getWorkflowPackageFile(artifactId, "*").getAbsolutePath()));
        }
        return new CoansysWorkflowPackage(candidates[0]);
    }

    private String getWorkflowPackageFileName(String artifactId, String version) {
        return artifactId + "-" + version + "-" + ARTIFACT_CLASSIFIER + "." + ARTIFACT_TYPE;
    }

    private File getWorkflowPackageFile(String artifactId, String version) {
        return new File(this.dir, this.getWorkflowPackageFileName(artifactId, version));
    }
}

