/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.primer;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.io.IOUtils;

public final class ImportLinkFileChecker {
    public static final String IMPORT_LINK_FILE_NAME = "import.txt";
    public static final String IMPORT_LINK_HEADER = "## This is a classpath-based import file (this header is required)";
    private static final String SPLITTING_REGEX = "[^A-Za-z0-9#]+";

    private ImportLinkFileChecker() {
    }

    public static boolean checkName(File f) {
        return f.getName().equalsIgnoreCase(IMPORT_LINK_FILE_NAME);
    }

    public static void dropHeader(BufferedReader reader) throws IOException {
        reader.readLine();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkHeader(InputStream is) {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(is));
            String header = reader.readLine();
            boolean bl = ImportLinkFileChecker.checkHeaderContents(header);
            IOUtils.closeQuietly((Reader)reader);
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(reader);
        }
    }

    public static boolean checkHeaderContents(String header) {
        Object[] actual = ImportLinkFileChecker.splitHeader(header);
        Object[] expected = ImportLinkFileChecker.splitHeader(IMPORT_LINK_HEADER);
        return Arrays.equals(actual, expected);
    }

    private static String[] splitHeader(String header) {
        return header.trim().toLowerCase(Locale.ENGLISH).split(SPLITTING_REGEX);
    }
}

