/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.primer;

import eu.dnetlib.iis.primer.ClassProvider;
import eu.dnetlib.iis.primer.Resolver;
import eu.dnetlib.iis.primer.UnresolvableResourceException;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.log4j.Logger;

public class Loader {
    private final Logger log = Logger.getLogger(Loader.class);
    private SortedMap<String, ClassProvider> index = new TreeMap<String, ClassProvider>();

    public void addClassProvider(ClassProvider classProvider) {
        List<String> entryNames = classProvider.getEntryNames();
        Collections.sort(entryNames);
        String exclusionPrefix = null;
        for (String s : entryNames) {
            if (exclusionPrefix != null && s.startsWith(exclusionPrefix)) {
                this.log.warn((Object)("Omitting " + s + " as it is a descendant of inconsistently duplicated " + exclusionPrefix));
                continue;
            }
            exclusionPrefix = null;
            if (this.index.containsKey(Loader.toggleTailingSlash(s))) {
                this.log.warn((Object)("Inconsistent duplicated entries for " + s + ". Will use the first one."));
                exclusionPrefix = s;
                continue;
            }
            if (this.index.containsKey(s)) {
                this.log.warn((Object)("Duplicated entries for " + s));
            }
            this.index.put(s, classProvider);
        }
    }

    private static String toggleTailingSlash(String s) {
        if (s.endsWith("/")) {
            return s.substring(0, s.length() - 1);
        }
        return s + "/";
    }

    public void prime(String classpath, File destination, Resolver resolver) throws UnresolvableResourceException {
        boolean didAnything = false;
        SortedMap<String, ClassProvider> tail = this.index.tailMap(classpath);
        for (Map.Entry<String, ClassProvider> entry : tail.entrySet()) {
            if (!entry.getKey().startsWith(classpath)) break;
            try {
                entry.getValue().primeOne(entry.getKey(), new File(destination, entry.getKey().substring(classpath.length())), resolver);
                didAnything = true;
            }
            catch (Exception e) {
                throw new UnresolvableResourceException(e);
            }
        }
        if (!didAnything) {
            throw new UnresolvableResourceException("Could not resolve " + classpath + " using the classpath");
        }
    }
}

