/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.maven.plugin.properties;

import java.io.File;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public class GenerateOoziePropertiesMojo
extends AbstractMojo {
    public static final String PROPERTY_NAME_WF_SOURCE_DIR = "workflow.source.dir";
    public static final String PROPERTY_NAME_SANDBOX_NAME = "sandboxName";
    private final String[] limiters = new String[]{"iis", "dnetlib", "eu"};

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (System.getProperties().containsKey(PROPERTY_NAME_WF_SOURCE_DIR) && !System.getProperties().containsKey(PROPERTY_NAME_SANDBOX_NAME)) {
            String generatedSandboxName = this.generateSandboxName(System.getProperties().getProperty(PROPERTY_NAME_WF_SOURCE_DIR));
            if (generatedSandboxName != null) {
                System.getProperties().setProperty(PROPERTY_NAME_SANDBOX_NAME, generatedSandboxName);
            } else {
                System.out.println("unable to generate sandbox name from path: " + System.getProperties().getProperty(PROPERTY_NAME_WF_SOURCE_DIR));
            }
        }
    }

    private String generateSandboxName(String wfSourceDir) {
        ArrayList<Object> sandboxNameParts = new ArrayList<Object>();
        Object[] tokens = StringUtils.split((String)wfSourceDir, (char)File.separatorChar);
        ArrayUtils.reverse((Object[])tokens);
        if (tokens.length > 0) {
            for (Object token : tokens) {
                for (String limiter : this.limiters) {
                    if (!limiter.equals(token)) continue;
                    return sandboxNameParts.size() > 0 ? StringUtils.join((Object[])sandboxNameParts.toArray()) : null;
                }
                if (sandboxNameParts.size() > 0) {
                    sandboxNameParts.add(0, File.separator);
                }
                sandboxNameParts.add(0, token);
            }
            if (sandboxNameParts.size() > 0) {
                return StringUtils.join((Object[])sandboxNameParts.toArray());
            }
            return null;
        }
        return null;
    }
}

