/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.utility.cleaner;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import eu.dnetlib.data.utility.cleaner.XPATHCleaningRule;
import eu.dnetlib.data.utility.cleaner.rmi.CleanerException;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VocabularyRule
extends XPATHCleaningRule {
    private Set<String> vocabularies;
    private static final Log log = LogFactory.getLog(VocabularyRule.class);
    private Map<String, String> synonyms = Maps.newHashMap();
    private Set<String> validTerms = Sets.newHashSet();

    public VocabularyRule(Set<String> vocabularies, ServiceLocator<ISLookUpService> lookupLocator) throws CleanerException {
        this.vocabularies = vocabularies;
        this.loadSynonymsAndTerms(lookupLocator);
    }

    @Override
    protected String calculateNewValue(String oldValue) throws CleanerException {
        log.debug((Object)("calculating new value for: " + oldValue));
        if (this.synonyms.isEmpty()) {
            log.warn((Object)("Vocabulary terms is void, vocabularies: " + this.vocabularies));
        }
        String newValue = null;
        if (this.synonyms.containsKey(oldValue.toLowerCase())) {
            newValue = this.synonyms.get(oldValue.toLowerCase());
        }
        if (newValue == null) {
            log.debug((Object)("Synonym " + oldValue + " not found in vocabulary"));
            return oldValue;
        }
        return newValue;
    }

    private void loadSynonymsAndTerms(ServiceLocator<ISLookUpService> lookupLocator) throws CleanerException {
        for (String vocabulary : this.vocabularies) {
            try {
                String query = "for $x in collection('/db/DRIVER/VocabularyDSResources/VocabularyDSResourceType')//RESOURCE_PROFILE[.//VOCABULARY_NAME/@code='" + vocabulary + "']//TERM return " + "( concat($x/@code,'|-:-|', $x/@code), concat($x/@english_name,'|-:-|', $x/@code), concat($x/@native_name,'|-:-|', $x/@code), " + "for $y in $x//SYNONYM return concat($y/@term,'|-:-|', $x/@code) )";
                for (String s : ((ISLookUpService)lookupLocator.getService()).quickSearchProfile(query)) {
                    log.debug((Object)("SYNONYM : " + s));
                    String[] arr = s.split("\\|-:-\\|");
                    if (arr[0] == null || arr[0].isEmpty()) continue;
                    this.synonyms.put(arr[0].toLowerCase(), arr[1]);
                    this.validTerms.add(arr[1].toLowerCase());
                }
                log.info((Object)("VOCABULARY " + vocabulary.trim() + " - terms size " + this.synonyms.size()));
            }
            catch (Exception e) {
                throw new CleanerException("Error obtaining vocabulary " + vocabulary, (Throwable)e);
            }
        }
    }

    @Override
    protected Map<String, String> verifyValue(String value) throws CleanerException {
        if (this.synonyms.isEmpty()) {
            log.warn((Object)("Vocabulary terms is void, vocabularies: " + this.vocabularies));
        }
        if (this.validTerms.contains(value.toLowerCase())) {
            return null;
        }
        HashMap<String, String> error = new HashMap<String, String>();
        error.put("term", value);
        error.put("vocabularies", this.vocabularies.toString().replaceAll("\\[", "").replaceAll("\\]", ""));
        error.put("xpath", this.getXpath());
        return error;
    }

    public Map<String, String> getVocabularyTerms() {
        return this.synonyms;
    }

    public String toString() {
        return "VOCABULARIES: [" + Joiner.on((String)", ").join(this.vocabularies) + "]";
    }
}

