/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.utility.cleaner;

import eu.dnetlib.data.utility.cleaner.CleaningRuleFactory;
import eu.dnetlib.data.utility.cleaner.rmi.CleanerException;
import eu.dnetlib.data.utility.cleaner.rmi.CleanerService;
import eu.dnetlib.enabling.resultset.MappedResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.miscutils.functional.UnaryFunction;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class CleanerServiceImpl
extends AbstractBaseService
implements CleanerService {
    private CleaningRuleFactory cleaningRuleFactory;
    private MappedResultSetFactory mappedResultSetFactory;

    public W3CEndpointReference clean(W3CEndpointReference epr, String ruleId) throws CleanerException {
        if (ruleId == null || ruleId.isEmpty()) {
            throw new CleanerException("Invalid ruleId: id is empty");
        }
        if (epr == null) {
            throw new CleanerException("Passed epr is empty");
        }
        return this.mappedResultSetFactory.createMappedResultSet(epr, (UnaryFunction)this.cleaningRuleFactory.obtainCleaningRule(ruleId));
    }

    @Required
    public MappedResultSetFactory getMappedResultSetFactory() {
        return this.mappedResultSetFactory;
    }

    @Required
    public void setMappedResultSetFactory(MappedResultSetFactory mappedResultSetFactory) {
        this.mappedResultSetFactory = mappedResultSetFactory;
    }

    public CleaningRuleFactory getCleaningRuleFactory() {
        return this.cleaningRuleFactory;
    }

    @Required
    public void setCleaningRuleFactory(CleaningRuleFactory cleaningRuleFactory) {
        this.cleaningRuleFactory = cleaningRuleFactory;
    }
}

