/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.jaxb;

import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlRegistry;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

@XmlRegistry
public class JaxbFactory<T> {
    private JAXBContext context;
    private Class<T> clazz;

    protected JaxbFactory() throws JAXBException {
    }

    public JaxbFactory(Class<? extends T> clazz) throws JAXBException {
        this(clazz, new Class[0]);
    }

    public JaxbFactory(Class<? extends T> clazz, Class<?> ... classes) throws JAXBException {
        Class[] all = new Class[classes.length + 1];
        for (int i = 0; i < classes.length; ++i) {
            all[i + 1] = classes[i];
        }
        all[0] = clazz;
        this.clazz = clazz;
        this.context = JAXBContext.newInstance((Class[])all);
    }

    public T newInstance() {
        try {
            return this.clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException("jaxb bean not instantiable, e");
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("jaxb bean not instantiable, e");
        }
    }

    public T parse(String value) throws JAXBException {
        return this.parse(new StreamSource(new StringReader(value)));
    }

    public T parse(Source source) throws JAXBException {
        Unmarshaller unmarshaller = this.context.createUnmarshaller();
        return (T)unmarshaller.unmarshal(source);
    }

    public String serialize(T value) throws JAXBException {
        Marshaller marshaller = this.context.createMarshaller();
        StringWriter buffer = new StringWriter();
        marshaller.marshal(this.createElement(value), (Writer)buffer);
        return buffer.toString();
    }

    public void serialize(T value, Result result) throws JAXBException {
        Marshaller marshaller = this.context.createMarshaller();
        marshaller.marshal(this.createElement(value), result);
    }

    protected JAXBElement<T> createElement(T value) {
        XmlRootElement ann = this.findAnnotation(XmlRootElement.class, this.clazz);
        return new JAXBElement(new QName(ann.namespace(), ann.name()), this.clazz, null, value);
    }

    private <X extends Annotation> X findAnnotation(Class<X> annotation, Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        X ann = clazz.getAnnotation(annotation);
        if (ann != null) {
            return ann;
        }
        for (Class<?> iface : clazz.getInterfaces()) {
            X iann = this.findAnnotation(annotation, iface);
            if (iann == null) continue;
            return iann;
        }
        X parent = this.findAnnotation(annotation, clazz.getSuperclass());
        if (parent != null) {
            return parent;
        }
        return null;
    }

    public JAXBContext getContext() {
        return this.context;
    }

    public void setContext(JAXBContext context) {
        this.context = context;
    }

    public Class<? extends T> getClazz() {
        return this.clazz;
    }

    public void setClazz(Class<T> clazz) {
        this.clazz = clazz;
    }
}

