/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.miscutils.hstree;

import eu.dnetlib.miscutils.hstree.NilTreeNode;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeNode<T, N, V, C extends TreeNode<N, ?, V, ?>> {
    public static final String CHILDR_UNDER_LEAF = "cannot create children under leaf nodes";
    private static final Log log = LogFactory.getLog(TreeNode.class);
    T resource;
    List<C> children = new ArrayList<C>();
    transient Class<? extends C> childNodeType = this.autoChildNodeType(this.getClass());

    protected TreeNode() {
    }

    protected TreeNode(T resource) {
        this.resource = resource;
    }

    public C addChild(N resource) {
        try {
            TreeNode test;
            if (this.childNodeType.equals(NilTreeNode.class)) {
                throw new IllegalStateException(CHILDR_UNDER_LEAF);
            }
            try {
                test = (TreeNode)this.childNodeType.newInstance();
                test.setResource(resource);
            }
            catch (InstantiationException e) {
                try {
                    test = (TreeNode)this.childNodeType.getConstructors()[0].newInstance(resource);
                }
                catch (InvocationTargetException e1) {
                    throw new IllegalStateException(e1);
                }
                catch (InstantiationException e1) {
                    throw new IllegalStateException(e1);
                }
            }
            this.getChildren().add(test);
            return (C)test;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException(e);
        }
        catch (SecurityException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public TreeNode<T, N, V, C> appendChild(N resource) {
        this.addChild(resource);
        return this;
    }

    public void breadthFirst(V visitor) {
        LinkedList<TreeNode<T, N, V, C>> queue = new LinkedList<TreeNode<T, N, V, C>>();
        queue.add(this);
        while (!queue.isEmpty()) {
            TreeNode current = (TreeNode)queue.remove();
            log.info((Object)("visiting " + current));
            current.accept(visitor);
            queue.addAll(current.getChildren());
        }
    }

    public void depthFirst(V visitor) {
        this.baseDepthFirst(visitor);
    }

    public void baseDepthFirst(V visitor) {
        this.accept(visitor);
        for (TreeNode el : this.children) {
            el.baseDepthFirst(visitor);
        }
    }

    protected Class<? extends C> autoChildNodeType(Class<? extends TreeNode> clazz) {
        Type superType = clazz.getGenericSuperclass();
        if (superType instanceof ParameterizedType) {
            ParameterizedType paramSuperType = (ParameterizedType)superType;
            int argumentIndex = paramSuperType.getRawType() == TreeNode.class ? 3 : 2;
            Type argument = paramSuperType.getActualTypeArguments()[argumentIndex];
            return (Class)this.getRawType(argument);
        }
        return this.autoChildNodeType((Class)superType);
    }

    protected <X> X getRawType(Type type) {
        if (type instanceof ParameterizedType) {
            return (X)((ParameterizedType)type).getRawType();
        }
        return (X)type;
    }

    public List<C> getChildren() {
        return this.children;
    }

    public void setChildren(List<C> children) {
        this.children = children;
    }

    public T getResource() {
        return this.resource;
    }

    public void setResource(T resource) {
        this.resource = resource;
    }

    public void accept(V dummy) {
        log.fatal((Object)"should be ovverriden");
    }
}

