package eu.dnetlib.data.mdstore.modular;

import java.util.List;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;

public class ModularMDStoreService extends AbstractBaseService implements MDStoreService {

	/**
	 * notification handler.
	 */
	private NotificationHandler notificationHandler;

	private MDStoreFeeder feeder;

	private MDStoreRetriever retriever;

	private IterableResultSetFactory iterableResultSetFactory;

	@Override
	public W3CEndpointReference deliverMDRecords(final String mdId, final String from, final String until, final String recordFilter)
			throws MDStoreServiceException {
		return retriever.deliver(mdId, from, until, recordFilter);
	}

	@Override
	public W3CEndpointReference bulkDeliverMDRecords(final String format, final String layout, final String interpretation) {
		return getIterableResultSetFactory().createIterableResultSet(retriever.deliver(format, layout, interpretation));
	}

	@Override
	public String deliverRecord(final String mdId, final String recordId) throws MDStoreServiceException {
		return retriever.deliverRecord(mdId, recordId);
	}

	@Override
	public List<String> getListOfMDStores() {
		return retriever.getDao().listMDStores();
	}

	@Override
	public List<String> listMDStores(final String format, final String layout, final String interpretation) {
		return retriever.getDao().listMDStores(format, layout, interpretation);
	}

	@Override
	public boolean storeMDRecordsFromRS(final String mdId, final String rsEpr, final String storingType) {
		feeder.feed(mdId, rsEpr, storingType);
		return true;
	}

	@Override
	public void notify(final String subscriptionId, final String topic, final String isId, final String message) {
		getNotificationHandler().notified(subscriptionId, topic, isId, message);
	}

	public NotificationHandler getNotificationHandler() {
		return notificationHandler;
	}

	@Required
	public void setNotificationHandler(final NotificationHandler notificationHandler) {
		this.notificationHandler = notificationHandler;
	}

	public MDStoreFeeder getFeeder() {
		return feeder;
	}

	public void setFeeder(final MDStoreFeeder feeder) {
		this.feeder = feeder;
	}

	public MDStoreRetriever getRetriever() {
		return retriever;
	}

	public void setRetriever(final MDStoreRetriever retriever) {
		this.retriever = retriever;
	}

	public IterableResultSetFactory getIterableResultSetFactory() {
		return iterableResultSetFactory;
	}

	@Required
	public void setIterableResultSetFactory(final IterableResultSetFactory iterableResultSetFactory) {
		this.iterableResultSetFactory = iterableResultSetFactory;
	}

}
