package eu.dnetlib.data.mdstore.modular;

import org.springframework.beans.factory.annotation.Required;

import eu.dnetlib.enabling.is.registry.ISRegistryDocumentNotFoundException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;

public class DeleteAction extends AbstractMDStoreAction implements BlackboardServerAction<MDStoreActions> {

	private ServiceLocator<ISRegistryService> registryLocator;

	@Override
	public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws ISRegistryDocumentNotFoundException, ISRegistryException {
		registryLocator.getService().deleteProfile(job.getParameters().get("id"));

		getDao().deleteMDStore(job.getParameters().get("id"));

		handler.done(job);
	}

	public ServiceLocator<ISRegistryService> getRegistryLocator() {
		return registryLocator;
	}

	@Required
	public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
		this.registryLocator = registryLocator;
	}

}