/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreFeeder {
    private MDStoreDao dao;
    private ResultSetClientFactory resultSetClientFactory;
    private ServiceLocator<ISRegistryService> registryLocator;
    private boolean syncFeed = true;
    static final Log log = LogFactory.getLog(MDStoreFeeder.class);

    public void feed(String mdId, String rsEpr, String storingType) {
        this.feed(mdId, rsEpr, storingType, this.syncFeed, null, null);
    }

    public void feed(final String mdId, final String rsEpr, final String storingType, boolean sync, final Callable<?> callback, final Callable<?> failCallback) {
        log.info((Object)("Start feeding mdstore " + mdId + " with epr " + rsEpr));
        Thread feederThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block8: {
                    try {
                        boolean incremental;
                        MDStore mdstore = MDStoreFeeder.this.dao.getMDStore(mdId);
                        IterableResultSetClient records = MDStoreFeeder.this.resultSetClientFactory.getClient(rsEpr);
                        boolean bl = incremental = !"REFRESH".equals(storingType);
                        if (!incremental) {
                            mdstore.truncate();
                        }
                        int size = mdstore.feed((Iterable<String>)records, incremental);
                        MDStoreFeeder.this.touch(mdId, size);
                        log.info((Object)("Stop feeding mdstore " + mdId + " - new size: " + size));
                        if (callback != null) {
                            try {
                                callback.call();
                            }
                            catch (Exception e) {
                                log.error((Object)"Error executing callback", (Throwable)e);
                            }
                        }
                    }
                    catch (Throwable e) {
                        log.error((Object)"Error in feeding thread", e);
                        if (failCallback == null) break block8;
                        try {
                            failCallback.call();
                        }
                        catch (Exception e1) {
                            log.error((Object)"Error executing failCallback", e);
                        }
                    }
                }
            }
        });
        feederThread.start();
        if (sync) {
            try {
                feederThread.join();
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public void touch(String mdId, int size) {
        try {
            String now = DateUtils.now_ISO8601();
            String mdstoreXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + mdId + "']" + "return update value $x//LAST_STORAGE_DATE with '" + now + "'";
            ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(mdstoreXUpdate);
            this.touchSize(mdId, size);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void touchSize(String mdId, int size) {
        try {
            String mdstoreNumberXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + mdId + "']" + "return update value $x//NUMBER_OF_RECORDS with '" + size + "'";
            ((ISRegistryService)this.registryLocator.getService()).executeXUpdate(mdstoreNumberXUpdate);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public MDStoreDao getDao() {
        return this.dao;
    }

    @Required
    public void setDao(MDStoreDao dao) {
        this.dao = dao;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }

    public boolean isSyncFeed() {
        return this.syncFeed;
    }

    public void setSyncFeed(boolean syncFeed) {
        this.syncFeed = syncFeed;
    }
}

