/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.AbstractMDStoreAction;
import eu.dnetlib.data.mdstore.modular.MDStoreActions;
import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.util.concurrent.Callable;
import org.springframework.beans.factory.annotation.Required;

public class FeedAction
extends AbstractMDStoreAction
implements BlackboardServerAction<MDStoreActions> {
    private MDStoreFeeder feeder;

    public void execute(final BlackboardServerHandler handler, final BlackboardJob job) throws Exception {
        final String mdId = (String)job.getParameters().get("mdId");
        if (mdId == null || mdId.isEmpty()) {
            throw new MDStoreServiceException("Blackboard param (mdId) is empty");
        }
        String epr = (String)job.getParameters().get("epr");
        if (epr == null || epr.isEmpty()) {
            throw new MDStoreServiceException("Blackboard param (mdId) is empty");
        }
        String storingType = (String)job.getParameters().get("storingType");
        if (storingType == null || storingType.isEmpty()) {
            storingType = "REFRESH";
        }
        this.feeder.feed(mdId, epr, storingType, true, new Callable<Object>(){

            @Override
            public Object call() {
                job.getParameters().put("total", "" + FeedAction.this.getDao().getMDStore(mdId).getSize());
                handler.done(job);
                return null;
            }
        }, new Callable<Object>(){

            @Override
            public Object call() {
                handler.failed(job, (Throwable)new Exception("Error during feeding of " + mdId));
                return null;
            }
        });
    }

    public MDStoreFeeder getFeeder() {
        return this.feeder;
    }

    @Required
    public void setFeeder(MDStoreFeeder feeder) {
        this.feeder = feeder;
    }
}

