package eu.dnetlib.data.mdstore.modular;

import javax.xml.ws.wsaddressing.W3CEndpointReference;

import org.springframework.beans.factory.annotation.Required;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;

import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.enabling.resultset.ResultSetFactory;

public class MDStoreRetriever {

	private MDStoreDao dao;

	private ResultSetFactory resultSetFactory;

	public W3CEndpointReference deliver(final String mdId, final String from, final String until, final String recordFilter) {

		final MDStore mdStore = dao.getMDStore(mdId);

		return getResultSetFactory().createResultSet(mdStore.deliver(from, until, recordFilter));
	}

	public Iterable<String> deliver(final String format, final String layout, final String interpretation) {
		return Iterables.concat(Iterables.transform(dao.listMDStores(format, layout, interpretation), new Function<String, Iterable<String>>() {

			@Override
			public Iterable<String> apply(final String mdId) {
				return dao.getMDStore(mdId).iterate();
			}
		}));
	}

	public String deliverRecord(final String mdId, final String recordId) throws DocumentNotFoundException {
		return dao.getMDStore(mdId).getRecord(recordId);
	}

	public MDStoreDao getDao() {
		return dao;
	}

	@Required
	public void setDao(final MDStoreDao dao) {
		this.dao = dao;
	}

	@Required
	public void setResultSetFactory(final ResultSetFactory resultSetFactory) {
		this.resultSetFactory = resultSetFactory;
	}

	public ResultSetFactory getResultSetFactory() {
		return resultSetFactory;
	}

}
