/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.enabling.resultset.ResultSetFactory;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreRetriever {
    private MDStoreDao dao;
    private ResultSetFactory resultSetFactory;

    public W3CEndpointReference deliver(String mdId, String from, String until, String recordFilter) {
        MDStore mdStore = this.dao.getMDStore(mdId);
        return this.getResultSetFactory().createResultSet(mdStore.deliver(from, until, recordFilter));
    }

    public Iterable<String> deliver(String format, String layout, String interpretation) {
        return Iterables.concat((Iterable)Iterables.transform(this.dao.listMDStores(format, layout, interpretation), (Function)new Function<String, Iterable<String>>(){

            public Iterable<String> apply(String mdId) {
                return MDStoreRetriever.this.dao.getMDStore(mdId).iterate();
            }
        }));
    }

    public String deliverRecord(String mdId, String recordId) throws DocumentNotFoundException {
        return this.dao.getMDStore(mdId).getRecord(recordId);
    }

    public MDStoreDao getDao() {
        return this.dao;
    }

    @Required
    public void setDao(MDStoreDao dao) {
        this.dao = dao;
    }

    @Required
    public void setResultSetFactory(ResultSetFactory resultSetFactory) {
        this.resultSetFactory = resultSetFactory;
    }

    public ResultSetFactory getResultSetFactory() {
        return this.resultSetFactory;
    }
}

