/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.data.mdstore.modular.MDStoreRetriever;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class ModularMDStoreService
extends AbstractBaseService
implements MDStoreService {
    private NotificationHandler notificationHandler;
    private MDStoreFeeder feeder;
    private MDStoreRetriever retriever;
    private IterableResultSetFactory iterableResultSetFactory;

    public W3CEndpointReference deliverMDRecords(String mdId, String from, String until, String recordFilter) throws MDStoreServiceException {
        return this.retriever.deliver(mdId, from, until, recordFilter);
    }

    public W3CEndpointReference bulkDeliverMDRecords(String format, String layout, String interpretation) {
        return this.getIterableResultSetFactory().createIterableResultSet(this.retriever.deliver(format, layout, interpretation));
    }

    public String deliverRecord(String mdId, String recordId) throws DocumentNotFoundException {
        return this.retriever.deliverRecord(mdId, recordId);
    }

    public List<String> getListOfMDStores() {
        return this.retriever.getDao().listMDStores();
    }

    public List<String> listMDStores(String format, String layout, String interpretation) {
        return this.retriever.getDao().listMDStores(format, layout, interpretation);
    }

    public boolean storeMDRecordsFromRS(String mdId, String rsEpr, String storingType) {
        this.feeder.feed(mdId, rsEpr, storingType);
        return true;
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public MDStoreFeeder getFeeder() {
        return this.feeder;
    }

    public void setFeeder(MDStoreFeeder feeder) {
        this.feeder = feeder;
    }

    public MDStoreRetriever getRetriever() {
        return this.retriever;
    }

    public void setRetriever(MDStoreRetriever retriever) {
        this.retriever = retriever;
    }

    public IterableResultSetFactory getIterableResultSetFactory() {
        return this.iterableResultSetFactory;
    }

    @Required
    public void setIterableResultSetFactory(IterableResultSetFactory iterableResultSetFactory) {
        this.iterableResultSetFactory = iterableResultSetFactory;
    }
}

