/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.AbstractMDStoreAction;
import eu.dnetlib.data.mdstore.modular.MDStoreActions;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreTransactionManager;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class DeleteAction
extends AbstractMDStoreAction
implements BlackboardServerAction<MDStoreActions> {
    private ServiceLocator<ISRegistryService> registryLocator;
    @Autowired
    private MDStoreTransactionManager transactionManager;

    @Override
    public void executeAsync(BlackboardServerHandler handler, BlackboardJob job) throws MDStoreServiceException {
        String currentId = (String)job.getParameters().get("id");
        try {
            ((ISRegistryService)this.registryLocator.getService()).deleteProfile(currentId);
            this.transactionManager.dropMDStore(currentId);
            this.getDao().deleteMDStore(currentId);
            handler.done(job);
        }
        catch (Exception e) {
            throw new MDStoreServiceException("Error deleting mdstore with id " + currentId, (Throwable)e);
        }
    }

    public ServiceLocator<ISRegistryService> getRegistryLocator() {
        return this.registryLocator;
    }

    @Required
    public void setRegistryLocator(ServiceLocator<ISRegistryService> registryLocator) {
        this.registryLocator = registryLocator;
    }
}

