/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.AbstractMDStoreAction;
import eu.dnetlib.data.mdstore.modular.FeedDoneCallback;
import eu.dnetlib.data.mdstore.modular.FeedFailedCallback;
import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class FeedAction
extends AbstractMDStoreAction {
    private static final Log log = LogFactory.getLog(FeedAction.class);
    private MDStoreFeeder feeder;

    @Override
    public void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) throws MDStoreServiceException {
        final String mdId = (String)job.getParameters().get("mdId");
        if (mdId == null || mdId.isEmpty()) {
            throw new MDStoreServiceException("Blackboard param (mdId) is empty");
        }
        String epr = (String)job.getParameters().get("epr");
        if (epr == null || epr.isEmpty()) {
            throw new MDStoreServiceException("Blackboard param (mdId) is empty");
        }
        String storingType = (String)job.getParameters().get("storingType");
        if (storingType == null || storingType.isEmpty()) {
            storingType = "REFRESH";
        }
        this.feeder.feed(mdId, epr, storingType, true, new FeedDoneCallback(){

            @Override
            public void call(int size) {
                job.getParameters().put("total", "" + size);
                handler.done(job);
            }
        }, new FeedFailedCallback(){

            @Override
            public void call(Throwable e) {
                log.error((Object)("Error feeding mdstore: " + mdId), e);
                handler.failed(job, e);
            }
        });
    }

    public MDStoreFeeder getFeeder() {
        return this.feeder;
    }

    @Required
    public void setFeeder(MDStoreFeeder feeder) {
        this.feeder = feeder;
    }
}

