/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import com.google.common.collect.Maps;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.action.DoneCallback;
import eu.dnetlib.data.mdstore.modular.action.FailedCallback;
import eu.dnetlib.data.mdstore.modular.connector.MDStore;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClientFactory;
import eu.dnetlib.miscutils.datetime.DateUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class MDStoreFeeder {
    private static final Log log = LogFactory.getLog(MDStoreFeeder.class);
    private MDStoreDao dao;
    private ResultSetClientFactory resultSetClientFactory;
    private UniqueServiceLocator serviceLocator;
    private boolean syncFeed = true;

    public void feed(String mdId, String rsEpr, String storingType, boolean sync, DoneCallback doneCallback, FailedCallback failCallback) throws MDStoreServiceException {
        log.info((Object)("Start feeding mdstore " + mdId));
        log.debug((Object)("Start feeding mdstore " + mdId + " with epr " + rsEpr));
        String transactionId = null;
        try {
            boolean refresh = "REFRESH".equals(storingType);
            MDStore mdstore = this.dao.startTransaction(mdId, refresh);
            transactionId = mdstore.getId();
            IterableResultSetClient records = this.resultSetClientFactory.getClient(rsEpr);
            if (refresh) {
                mdstore.truncate();
            }
            mdstore.feed((Iterable<String>)records, refresh);
            this.dao.commit(mdstore.getId(), mdId);
            int size = this.dao.refreshSize(mdId);
            this.touch(mdId, size);
            log.info((Object)("Finished feeding mdstore " + mdId + " - new size: " + size));
            doneCallback.call(this.buildParams(size));
        }
        catch (Throwable e) {
            if (transactionId != null) {
                this.dao.invalidTransaction(transactionId, mdId);
            }
            log.error((Object)("Error feeding mdstore: " + mdId));
            failCallback.call(e);
        }
    }

    private Map<String, String> buildParams(int size) {
        HashMap params = Maps.newHashMap();
        params.put("size", String.valueOf(size));
        return params;
    }

    public void touch(String mdId, int size) {
        try {
            String now = DateUtils.now_ISO8601();
            String mdstoreXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + mdId + "']" + "return update value $x//LAST_STORAGE_DATE with '" + now + "'";
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).executeXUpdate(mdstoreXUpdate);
            this.touchSize(mdId, size);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public void touchSize(String mdId, int size) {
        try {
            String mdstoreNumberXUpdate = "for $x in //RESOURCE_PROFILE[.//RESOURCE_IDENTIFIER/@value = '" + mdId + "']" + "return update value $x//NUMBER_OF_RECORDS with '" + size + "'";
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).executeXUpdate(mdstoreNumberXUpdate);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public MDStoreDao getDao() {
        return this.dao;
    }

    @Required
    public void setDao(MDStoreDao dao) {
        this.dao = dao;
    }

    public ResultSetClientFactory getResultSetClientFactory() {
        return this.resultSetClientFactory;
    }

    @Required
    public void setResultSetClientFactory(ResultSetClientFactory resultSetClientFactory) {
        this.resultSetClientFactory = resultSetClientFactory;
    }

    public boolean isSyncFeed() {
        return this.syncFeed;
    }

    public void setSyncFeed(boolean syncFeed) {
        this.syncFeed = syncFeed;
    }

    public UniqueServiceLocator getServiceLocator() {
        return this.serviceLocator;
    }

    @Required
    public void setServiceLocator(UniqueServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }
}

