/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import eu.dnetlib.data.mdstore.DocumentNotFoundException;
import eu.dnetlib.data.mdstore.MDStoreService;
import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.MDStoreDescription;
import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.data.mdstore.modular.MDStoreRetriever;
import eu.dnetlib.enabling.resultset.IterableResultSetFactory;
import eu.dnetlib.enabling.tools.AbstractBaseService;
import eu.dnetlib.enabling.tools.blackboard.NotificationHandler;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.springframework.beans.factory.annotation.Required;

public class ModularMDStoreService
extends AbstractBaseService
implements MDStoreService {
    private NotificationHandler notificationHandler;
    private MDStoreFeeder feeder;
    private MDStoreRetriever retriever;
    private IterableResultSetFactory iterableResultSetFactory;

    public W3CEndpointReference deliverMDRecords(String mdId, String from, String until, String recordFilter) throws MDStoreServiceException {
        return this.retriever.deliver(mdId, from, until, recordFilter);
    }

    public W3CEndpointReference bulkDeliverMDRecords(String format, String layout, String interpretation) throws MDStoreServiceException {
        return this.getIterableResultSetFactory().createIterableResultSet(this.retriever.deliver(format, layout, interpretation));
    }

    public String deliverRecord(String mdId, String recordId) throws MDStoreServiceException, DocumentNotFoundException {
        return this.retriever.deliverRecord(mdId, recordId);
    }

    public List<String> getListOfMDStores() throws MDStoreServiceException {
        return Lists.transform(this.retriever.getDao().listMDStores(), (Function)new Function<MDStoreDescription, String>(){

            public String apply(MDStoreDescription input) {
                return input.getId();
            }
        });
    }

    public List<String> listMDStores(String format, String layout, String interpretation) throws MDStoreServiceException {
        return this.retriever.getDao().listMDStores(format, layout, interpretation);
    }

    public void notify(String subscriptionId, String topic, String isId, String message) {
        this.getNotificationHandler().notified(subscriptionId, topic, isId, message);
    }

    public boolean storeMDRecordsFromRS(String mdId, String rsId, String storingType) throws MDStoreServiceException {
        throw new MDStoreServiceException("not implemented, use the Blackboard asynchronous equivalent");
    }

    public int size(String mdId) throws MDStoreServiceException {
        return this.getRetriever().getDao().getCachedSize(mdId);
    }

    public int size(String format, String layout, String interpretation) throws MDStoreServiceException {
        return this.getRetriever().getDao().getSumOfSizes(format, layout, interpretation);
    }

    public NotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    @Required
    public void setNotificationHandler(NotificationHandler notificationHandler) {
        this.notificationHandler = notificationHandler;
    }

    public MDStoreFeeder getFeeder() {
        return this.feeder;
    }

    public void setFeeder(MDStoreFeeder feeder) {
        this.feeder = feeder;
    }

    public MDStoreRetriever getRetriever() {
        return this.retriever;
    }

    public void setRetriever(MDStoreRetriever retriever) {
        this.retriever = retriever;
    }

    public IterableResultSetFactory getIterableResultSetFactory() {
        return this.iterableResultSetFactory;
    }

    @Required
    public void setIterableResultSetFactory(IterableResultSetFactory iterableResultSetFactory) {
        this.iterableResultSetFactory = iterableResultSetFactory;
    }
}

