/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.action;

import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.action.MDStoreActions;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreDao;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryService;
import eu.dnetlib.enabling.locators.UniqueServiceLocator;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerAction;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.io.InputStream;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.Resource;
import org.antlr.stringtemplate.StringTemplate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.ClassPathResource;

public abstract class AbstractMDStoreAction
implements BlackboardServerAction<MDStoreActions> {
    @Resource
    private UniqueServiceLocator serviceLocator;
    private MDStoreDao dao;
    private final Executor executor = Executors.newCachedThreadPool();
    private static final Log log = LogFactory.getLog(AbstractMDStoreAction.class);
    private static final ClassPathResource mdstoreServiceStatusTemplate = new ClassPathResource("/eu/dnetlib/data/mdstore/modular/mdstoreServiceStatusTemplate.xml.st");

    protected abstract void executeAsync(BlackboardServerHandler var1, BlackboardJob var2) throws MDStoreServiceException;

    public void execute(final BlackboardServerHandler handler, final BlackboardJob job) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    handler.ongoing(job);
                    AbstractMDStoreAction.this.executeAsync(handler, job);
                }
                catch (MDStoreServiceException e) {
                    handler.failed(job, (Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeWithSuccess(BlackboardServerHandler handler, BlackboardJob job) {
        AbstractMDStoreAction abstractMDStoreAction = this;
        synchronized (abstractMDStoreAction) {
            this.updateMDStoreServiceProfile(job);
            handler.done(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeWithFail(BlackboardServerHandler handler, BlackboardJob job, Throwable e) {
        AbstractMDStoreAction abstractMDStoreAction = this;
        synchronized (abstractMDStoreAction) {
            this.updateMDStoreServiceProfile(job);
            handler.failed(job, e);
        }
    }

    private void updateMDStoreServiceProfile(BlackboardJob job) {
        String id = job.getServiceId();
        log.info((Object)("Updating mdstore service profile status, id: " + id));
        try {
            StringTemplate st = new StringTemplate(IOUtils.toString((InputStream)mdstoreServiceStatusTemplate.getInputStream()));
            st.setAttribute("status", (Object)this.dao.getDBStatus());
            ((ISRegistryService)this.serviceLocator.getService(ISRegistryService.class)).updateProfileNode(id, "//STATUS", st.toString());
        }
        catch (Exception e) {
            log.error((Object)("Error upadating profile " + id), (Throwable)e);
        }
    }

    public MDStoreDao getDao() {
        return this.dao;
    }

    public void setDao(MDStoreDao dao) {
        this.dao = dao;
    }
}

