/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.action;

import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.MDStoreProfileCreator;
import eu.dnetlib.data.mdstore.modular.action.AbstractMDStoreAction;
import eu.dnetlib.data.mdstore.modular.connector.MDStoreTransactionManager;
import eu.dnetlib.enabling.is.registry.rmi.ISRegistryException;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

public class CreateAction
extends AbstractMDStoreAction {
    private MDStoreProfileCreator profileCreator;
    @Autowired
    private MDStoreTransactionManager transactionManager;

    @Override
    public void executeAsync(BlackboardServerHandler handler, BlackboardJob job) throws MDStoreServiceException {
        String format = (String)job.getParameters().get("format");
        String interpretation = (String)job.getParameters().get("interpretation");
        String layout = (String)job.getParameters().get("layout");
        try {
            String mdId = this.profileCreator.registerProfile(format, interpretation, layout);
            this.transactionManager.createMDStore(mdId);
            this.getDao().createMDStore(mdId, format, interpretation, layout);
            job.getParameters().put("id", mdId);
            this.completeWithSuccess(handler, job);
        }
        catch (ISRegistryException e) {
            throw new MDStoreServiceException((Throwable)e);
        }
    }

    public MDStoreProfileCreator getProfileCreator() {
        return this.profileCreator;
    }

    @Required
    public void setProfileCreator(MDStoreProfileCreator profileCreator) {
        this.profileCreator = profileCreator;
    }
}

