/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.mdstore.modular.action;

import eu.dnetlib.data.mdstore.MDStoreServiceException;
import eu.dnetlib.data.mdstore.modular.MDStoreFeeder;
import eu.dnetlib.data.mdstore.modular.action.AbstractMDStoreAction;
import eu.dnetlib.data.mdstore.modular.action.DoneCallback;
import eu.dnetlib.data.mdstore.modular.action.FailedCallback;
import eu.dnetlib.enabling.tools.blackboard.BlackboardJob;
import eu.dnetlib.enabling.tools.blackboard.BlackboardServerHandler;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class FeedAction
extends AbstractMDStoreAction {
    private static final Log log = LogFactory.getLog(FeedAction.class);
    private MDStoreFeeder feeder;

    @Override
    public void executeAsync(final BlackboardServerHandler handler, final BlackboardJob job) throws MDStoreServiceException {
        final String mdId = (String)job.getParameters().get("mdId");
        if (mdId == null || mdId.isEmpty()) {
            throw new MDStoreServiceException("Blackboard param (mdId) is empty");
        }
        String epr = (String)job.getParameters().get("epr");
        if (epr == null || epr.isEmpty()) {
            throw new MDStoreServiceException("Blackboard param (mdId) is empty");
        }
        String storingType = (String)job.getParameters().get("storingType");
        if (storingType == null || storingType.isEmpty()) {
            storingType = "REFRESH";
        }
        this.feeder.feed(mdId, epr, storingType, true, new DoneCallback(){

            @Override
            public void call(Map<String, String> params) {
                job.getParameters().put("total", "" + params.get("size"));
                FeedAction.this.completeWithSuccess(handler, job);
            }
        }, new FailedCallback(){

            @Override
            public void call(Throwable e) {
                log.error((Object)("Error feeding mdstore: " + mdId), e);
                FeedAction.this.completeWithFail(handler, job, e);
            }
        });
    }

    public MDStoreFeeder getFeeder() {
        return this.feeder;
    }

    @Required
    public void setFeeder(MDStoreFeeder feeder) {
        this.feeder = feeder;
    }
}

