<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
	xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" exclude-result-prefixes="xsl xsi">

	<xsl:output omit-xml-declaration="yes" standalone="omit" indent="yes"/>
	
	<xsl:template match="/">
		<xsl:variable name="id" select="//FIELD[@name='grant_agreement_number']" />
		<xsl:variable name="title" select="//FIELD[@name='title']" />
		<xsl:variable name="acronym" select="//FIELD[@name='acronym']" />
		<xsl:variable name="fundingProgramme" select="//FIELD[@name='fundingprogramme']" />
		<xsl:variable name="idnamespace">
			<xsl:choose>
				<xsl:when test="$fundingProgramme = 'FP7'">info:eu-repo/grantAgreement/EC/FP7/</xsl:when>
				<xsl:when test="$fundingProgramme = 'WT'">info:eu-repo/grantAgreement/WT/</xsl:when>
				<xsl:otherwise>info:eu-repo/grantAgreement/</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<pair>
			<displayed-value><xsl:value-of select="concat($id, ' - ', $acronym, ' - ', $title)" /></displayed-value>
			<stored-value><xsl:value-of select="concat($idnamespace, $id)" /></stored-value>
		</pair>
	</xsl:template>

</xsl:stylesheet>