/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.enabling.resultset.client;

import eu.dnetlib.enabling.resultset.client.IterableResultSetClient;
import eu.dnetlib.enabling.resultset.client.ResultSetClient;
import eu.dnetlib.enabling.resultset.client.utils.EPRUtils;
import eu.dnetlib.enabling.resultset.rmi.ResultSetService;
import eu.dnetlib.enabling.tools.ServiceResolver;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Required;

public class ResultSetClientFactory
implements ResultSetClient {
    private static final Log log = LogFactory.getLog(ResultSetClientFactory.class);
    private ServiceResolver serviceResolver;
    private EPRUtils eprUtils;
    private int pageSize;
    private long timeout;

    public ResultSetClientFactory() {
        log.info((Object)"creating new ResultSetClientIterableFactory with default pageSize and timeout");
    }

    public ResultSetClientFactory(int pageSize, long timeout) throws IllegalArgumentException {
        if (pageSize <= 0 || timeout <= 0L) {
            throw new IllegalArgumentException("parameters pageSize and timeout must be greater than zero");
        }
        this.pageSize = pageSize;
        this.timeout = timeout;
    }

    @Override
    public IterableResultSetClient getClient(W3CEndpointReference epr, int pageSize) {
        ResultSetService resultSet = (ResultSetService)this.serviceResolver.getService(ResultSetService.class, epr);
        String rsId = this.serviceResolver.getResourceIdentifier(epr);
        return new IterableResultSetClient(resultSet, rsId, pageSize, this.timeout);
    }

    @Override
    public IterableResultSetClient getClient(W3CEndpointReference epr) {
        ResultSetService resultSet = (ResultSetService)this.serviceResolver.getService(ResultSetService.class, epr);
        String rsId = this.serviceResolver.getResourceIdentifier(epr);
        return new IterableResultSetClient(resultSet, rsId, this.pageSize, this.timeout);
    }

    @Override
    public IterableResultSetClient getClient(String stringEpr, int pageSize) {
        return this.getClient(this.eprUtils.getEpr(stringEpr), pageSize);
    }

    @Override
    public IterableResultSetClient getClient(String stringEpr) {
        return this.getClient(this.eprUtils.getEpr(stringEpr));
    }

    @Required
    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    @Required
    public void setEprUtils(EPRUtils eprUtils) {
        this.eprUtils = eprUtils;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    @Required
    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public long getTimeout() {
        return this.timeout;
    }

    @Required
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

