/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.soap.cxf;

import eu.dnetlib.soap.cxf.CxfEndpointReferenceBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.cxf.endpoint.Endpoint;
import org.springframework.beans.factory.annotation.Required;

public class StandaloneCxfEndpointReferenceBuilder
extends CxfEndpointReferenceBuilder {
    private static final Log log = LogFactory.getLog(StandaloneCxfEndpointReferenceBuilder.class);
    private String baseAddress;
    private String absoluteBase;
    private boolean forceLocalAddress = false;

    public String getBaseAddress() {
        return this.baseAddress;
    }

    public void setBaseAddress(String baseAddress) {
        this.baseAddress = baseAddress;
    }

    @PostConstruct
    public void init() throws URISyntaxException {
        URI base = new URI(this.baseAddress);
        log.info((Object)("base address: " + this.baseAddress));
        this.absoluteBase = new URI(base.getScheme(), base.getUserInfo(), base.getHost(), base.getPort(), null, null, null).toString().trim();
        log.info((Object)("absolute base address: " + this.absoluteBase));
    }

    @Override
    public String getAddress(Endpoint endpoint) {
        String address = super.getAddress(endpoint);
        if (this.forceLocalAddress) {
            try {
                URI uri = new URI(address);
                if (!address.startsWith("http://")) {
                    String res = this.baseAddress + uri.getPath();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("fixing address to: " + res));
                    }
                    return res;
                }
                String res = this.absoluteBase + uri.getPath();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("forcing address to: " + res));
                }
                return res;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (!address.startsWith("http://") && this.baseAddress != null) {
            return this.baseAddress + address;
        }
        return address;
    }

    public boolean isForceLocalAddress() {
        return this.forceLocalAddress;
    }

    @Required
    public void setForceLocalAddress(boolean forceLocalAddress) {
        this.forceLocalAddress = forceLocalAddress;
    }
}

