/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.datasets;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import eu.dnetlib.data.collector.plugins.datasets.ElasticSearchResponse;
import eu.dnetlib.data.collector.plugins.datasets.PangaeaJournalInfo;
import eu.dnetlib.data.collector.plugins.datasets.RequestField;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class DatasetsIterator
implements Iterable<String>,
Iterator<String> {
    private static final Log log = LogFactory.getLog(DatasetsIterator.class);
    private static String BASE_URL_TEMPLATE = "http://ws.pangaea.de/es/pangaea/panmd/_search?_source=xml&size=%d&from=%d";
    private String journalId = "";
    private String journalName = "";
    private String journalISSN = "";
    private String openaireDatasource = "";
    private long total;
    private int from;
    private int currentIterator;
    private ElasticSearchResponse currentResponse;
    private RequestField request;
    private static int DEFAULT_SIZE = 10;
    private String projectCordaId;
    private static String RECORD_TEMPLATE = "<datasetsRecord><oaf:projectid xmlns:oaf=\"http://namespace.openaire.eu/oaf\">%s</oaf:projectid><journal name='%s' issn='%s' datasourceid = '%s'/><metadata>%s</metadata></datasetsRecord>";

    public DatasetsIterator(RequestField request, String projectCordaId, PangaeaJournalInfo info) {
        this.request = request;
        this.setProjectCordaId(projectCordaId);
        if (info != null) {
            this.setJournalId(info.getJournalId());
            this.setJournalName(StringEscapeUtils.escapeXml((String)info.getJournalName()));
            this.setJournalISSN(info.getJournalISSN());
            this.setOpenaireDatasource(info.getDatasourceId());
        }
        log.debug((Object)"Start Iterator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String executeQuery(int from, int size) {
        log.debug((Object)("executing query " + this.request.getQuery().getTerm()));
        log.debug((Object)String.format("from:%d size:%d", from, size));
        CloseableHttpResponse response = null;
        InputStream responseBody = null;
        CloseableHttpClient httpclient = HttpClients.createDefault();
        try {
            HttpPost post = new HttpPost(String.format(BASE_URL_TEMPLATE, size, from));
            Gson g = new GsonBuilder().disableHtmlEscaping().create();
            StringEntity entry = new StringEntity(g.toJson((Object)this.request));
            post.setEntity((HttpEntity)entry);
            long start = System.currentTimeMillis();
            response = httpclient.execute((HttpUriRequest)post);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                responseBody = response.getEntity().getContent();
                String s = IOUtils.toString((InputStream)responseBody);
                log.debug((Object)("Request done in " + (System.currentTimeMillis() - start) + " ms"));
                responseBody.close();
                String string = s;
                return string;
            }
            String string = null;
            return string;
        }
        catch (Exception e) {
            log.error((Object)("Error on executing query :" + this.request.getQuery().getTerm()), (Throwable)e);
            String string = null;
            return string;
        }
        finally {
            try {
                responseBody.close();
                response.close();
                httpclient.close();
            }
            catch (IOException e) {
                log.error((Object)"Can't close connections gracefully", (Throwable)e);
            }
        }
    }

    public String getJournalId() {
        return this.journalId;
    }

    public void setJournalId(String journalId) {
        this.journalId = journalId;
    }

    @Override
    public boolean hasNext() {
        return (long)(this.from + this.currentIterator) < this.total;
    }

    @Override
    public String next() {
        String xml = String.format(RECORD_TEMPLATE, this.projectCordaId, this.journalName, this.journalISSN, this.openaireDatasource, this.currentResponse.getXmlRecords().get(this.currentIterator));
        ++this.currentIterator;
        if (this.currentIterator == DEFAULT_SIZE) {
            this.getNextItem();
        }
        return xml;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<String> iterator() {
        this.from = 0;
        this.total = 0L;
        this.getNextItem();
        return this;
    }

    private void getNextItem() {
        this.from += this.currentIterator;
        this.currentResponse = ElasticSearchResponse.createNewResponse(this.executeQuery(this.from, DEFAULT_SIZE));
        this.total = this.currentResponse == null ? 0L : this.currentResponse.getTotal();
        log.debug((Object)("from : " + this.from + " total of the request is " + this.total));
        this.currentIterator = 0;
    }

    public String getProjectCordaId() {
        return this.projectCordaId;
    }

    public void setProjectCordaId(String projectCordaId) {
        this.projectCordaId = projectCordaId;
    }

    public String getJournalName() {
        return this.journalName;
    }

    public void setJournalName(String journalName) {
        this.journalName = journalName;
    }

    public String getJournalISSN() {
        return this.journalISSN;
    }

    public void setJournalISSN(String journalISSN) {
        this.journalISSN = journalISSN;
    }

    public String getOpenaireDatasource() {
        return this.openaireDatasource;
    }

    public void setOpenaireDatasource(String openaireDatasource) {
        this.openaireDatasource = openaireDatasource;
    }
}

