/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.collector.plugins.projects.wt;

import eu.dnetlib.data.collector.rmi.CollectorServiceException;
import eu.dnetlib.data.collector.rmi.CollectorServiceRuntimeException;
import eu.dnetlib.enabling.resultset.SizedIterable;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class WTProjectsIterable
implements SizedIterable<String> {
    private static final Log log = LogFactory.getLog(WTProjectsIterable.class);
    private String queryURL;
    private int total;
    private SAXReader reader;

    public WTProjectsIterable(String baseURL) throws CollectorServiceException {
        this.queryURL = baseURL;
        this.reader = new SAXReader();
        this.total = this.getTotalCount();
    }

    public int getNumberOfElements() {
        return this.total;
    }

    private int getTotalCount() throws CollectorServiceException {
        try {
            URL pageUrl = new URL(this.queryURL);
            log.debug((Object)("Getting hit count from: " + pageUrl.toString()));
            String resultPage = IOUtils.toString((URL)pageUrl);
            Document doc = this.reader.read(IOUtils.toInputStream((String)resultPage));
            String hitCount = doc.selectSingleNode("/Response/HitCount").getText();
            return Integer.parseInt(hitCount);
        }
        catch (NumberFormatException e) {
            log.warn((Object)"Cannot set the total count from '/Response/HitCount'");
        }
        catch (DocumentException e) {
            throw new CollectorServiceException((Throwable)e);
        }
        catch (MalformedURLException e) {
            throw new CollectorServiceException((Throwable)e);
        }
        catch (IOException e) {
            throw new CollectorServiceException((Throwable)e);
        }
        return -1;
    }

    public Iterator<String> iterator() {
        return new Iterator<String>(){
            private Queue<String> projects = new PriorityBlockingQueue<String>();
            private boolean morePages = true;
            private int pageNumber = 0;
            private SAXReader reader = new SAXReader();
            private int nextCounter = 0;

            @Override
            public boolean hasNext() {
                try {
                    this.fillProjectListIfNeeded();
                }
                catch (CollectorServiceException e) {
                    throw new CollectorServiceRuntimeException((Throwable)e);
                }
                return !this.projects.isEmpty();
            }

            @Override
            public String next() {
                ++this.nextCounter;
                log.debug((Object)String.format("Calling next %s times. projects queue has %s elements", this.nextCounter, this.projects.size()));
                try {
                    this.fillProjectListIfNeeded();
                    return this.projects.poll();
                }
                catch (CollectorServiceException e) {
                    throw new CollectorServiceRuntimeException((Throwable)e);
                }
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean fillProjectListIfNeeded() throws CollectorServiceException {
                if (this.morePages && this.projects.isEmpty()) {
                    String resultPage = this.getNextPage();
                    Document doc = null;
                    try {
                        doc = this.reader.read(IOUtils.toInputStream((String)resultPage));
                        List records = doc.selectNodes("//RecordList/Record");
                        if (records != null && !records.isEmpty()) {
                            for (Element p : records) {
                                this.projects.add(p.asXML());
                            }
                            return true;
                        }
                        log.info((Object)("No more projects to read at page nr. " + this.pageNumber));
                        this.morePages = false;
                        return false;
                    }
                    catch (DocumentException e) {
                        throw new CollectorServiceException((Throwable)e);
                    }
                }
                return false;
            }

            private String getNextPage() {
                ++this.pageNumber;
                try {
                    URL pageUrl = new URL(WTProjectsIterable.this.queryURL + "&page=" + this.pageNumber);
                    log.debug((Object)("Getting page at: " + pageUrl.toString()));
                    return IOUtils.toString((URL)pageUrl);
                }
                catch (Exception e) {
                    throw new CollectorServiceRuntimeException("Error on page " + this.pageNumber, (Throwable)e);
                }
            }
        };
    }
}

