/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.download.plugin.AbstractDownloadPlugin;
import java.util.ArrayList;
import java.util.List;

public class ArxivDownloadPlugin
extends AbstractDownloadPlugin
implements DownloadPlugin {
    public DownloadItem retrieveUrl(DownloadItem input) {
        if (this.checkOpenAccess(input) == null) {
            return null;
        }
        String url = input.getOriginalUrl();
        if (url == null || url.trim().length() == 0) {
            return input;
        }
        List urls = (List)new Gson().fromJson(url, ArrayList.class);
        if (urls == null || urls.size() == 0) {
            return input;
        }
        for (String s : urls) {
            if (!s.startsWith("http")) continue;
            input.setOriginalUrl(s);
            String correctUrl = s.replace("abs", "pdf");
            correctUrl = correctUrl + ".pdf";
            input.setUrl(correctUrl);
        }
        return input;
    }

    public Iterable<DownloadItem> retireveUrls(Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, (Function)new Function<DownloadItem, DownloadItem>(){

            public DownloadItem apply(DownloadItem input) {
                return ArxivDownloadPlugin.this.retrieveUrl(input);
            }
        });
    }

    public String getPluginName() {
        return "ArxivDownloadPlugin";
    }
}

