/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import eu.dnetlib.data.download.rmi.DownloadItem;
import org.joda.time.DateTime;
import org.joda.time.Days;
import org.joda.time.ReadableInstant;

public abstract class AbstractDownloadPlugin {
    public DownloadItem checkOpenAccess(DownloadItem input) {
        if (input != null) {
            DownloadItem.OpenAccessValues openAccess = DownloadItem.OpenAccessValues.valueOf((String)input.getOpenAccess());
            switch (openAccess) {
                case OPEN: {
                    return input;
                }
                case CLOSED: 
                case RESTRICTED: 
                case UNKNOWN: {
                    return null;
                }
                case EMBARGO: {
                    DateTime today;
                    if (input.getEmbargoDate() == null) {
                        return null;
                    }
                    DateTime embargoDate = new DateTime((Object)input.getEmbargoDate());
                    Days days = Days.daysBetween((ReadableInstant)embargoDate, (ReadableInstant)(today = new DateTime()));
                    if (days.getDays() <= 0) {
                        return input;
                    }
                    return null;
                }
            }
        }
        return null;
    }
}

