/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.download.plugin.AbstractDownloadPlugin;
import eu.dnetlib.download.plugin.PathRetreiver;
import java.util.ArrayList;
import java.util.List;

public class EuropePMC
extends AbstractDownloadPlugin
implements DownloadPlugin {
    private String basePath;

    public String getPluginName() {
        return "europePMCDownloadPlugin";
    }

    public Iterable<DownloadItem> retireveUrls(Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, (Function)new Function<DownloadItem, DownloadItem>(){

            public DownloadItem apply(DownloadItem input) {
                return EuropePMC.this.retrieveUrl(input);
            }
        });
    }

    public DownloadItem retrieveUrl(DownloadItem input) {
        String url = input.getOriginalUrl();
        if (url == null || url.trim().length() == 0) {
            return input;
        }
        List urls = (List)new Gson().fromJson(url, ArrayList.class);
        if (urls == null || urls.size() == 0) {
            return input;
        }
        input.setFileName(input.getIdItemMetadata());
        Boolean added = false;
        for (String s : urls) {
            if (s.startsWith("http")) {
                input.setOriginalUrl(s);
                continue;
            }
            if (!s.startsWith("PMC")) continue;
            String correctUrl = s.replace("PMC", "");
            added = true;
            String path = PathRetreiver.getInstance(null).getPathForPMCID(Integer.parseInt(correctUrl));
            if (path != null) {
                input.setUrl("file://" + path);
                continue;
            }
            input.setUrl(path);
        }
        if (!added.booleanValue()) {
            input.setOriginalUrl(null);
            input.setUrl(null);
        }
        return input;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

