/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.download.plugin;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.gson.Gson;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.download.rmi.DownloadPlugin;
import eu.dnetlib.download.plugin.AbstractDownloadPlugin;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class FollowPDFLinkPlugins
extends AbstractDownloadPlugin
implements DownloadPlugin {
    private static final Log log = LogFactory.getLog(FollowPDFLinkPlugins.class);

    private String extractURL(String url) {
        try {
            Document doc;
            Elements links;
            Iterator i$;
            URL startURL = new URL(url);
            HttpURLConnection conn = (HttpURLConnection)startURL.openConnection();
            conn.setInstanceFollowRedirects(true);
            HttpURLConnection.setFollowRedirects(true);
            String location = url;
            if (conn.getResponseCode() >= 300 && conn.getResponseCode() < 400) {
                location = conn.getHeaderFields().get("Location").get(0);
                conn.disconnect();
            }
            if ((i$ = (links = (doc = Jsoup.connect((String)location).get()).select("a[href$=.pdf]")).iterator()).hasNext()) {
                Element link = (Element)i$.next();
                String linkvalue = link.attr("abs:href");
                return linkvalue;
            }
            return null;
        }
        catch (Exception e) {
            log.error((Object)"Error on extract URL", (Throwable)e);
            return null;
        }
    }

    public Iterable<DownloadItem> retireveUrls(Iterable<DownloadItem> urls) {
        return Iterables.transform(urls, (Function)new Function<DownloadItem, DownloadItem>(){

            public DownloadItem apply(DownloadItem input) {
                return FollowPDFLinkPlugins.this.retrieveUrl(input);
            }
        });
    }

    public String getPluginName() {
        return "FollowPDFLinkPlugins";
    }

    public DownloadItem retrieveUrl(DownloadItem input) {
        if (this.checkOpenAccess(input) == null) {
            return null;
        }
        String url = input.getOriginalUrl();
        if (url == null || url.trim().length() == 0) {
            return input;
        }
        List urls = (List)new Gson().fromJson(url, ArrayList.class);
        if (urls == null || urls.size() == 0) {
            return input;
        }
        for (String s : urls) {
            String newURL = this.extractURL(s);
            if (newURL == null) continue;
            input.setOriginalUrl(s);
            input.setUrl(newURL);
            return input;
        }
        input.setOriginalUrl(null);
        input.setUrl(null);
        return input;
    }
}

