package eu.dnetlib.data.download.rmi;

import com.google.gson.Gson;

import eu.dnetlib.miscutils.functional.hash.Hashing;

/**
 * Download Item Class that serialize information in the resultset.
 */
public class DownloadItem {

	/** The id item metadata. */
	private String idItemMetadata;

	/** The Url. */
	private String Url;

	/** The file name. */
	private String fileName;

	/** The original URL should be appear instead of the downloaded URL */
	private String originalUrl;

	/**
	 * From json.
	 * 
	 * @param inputJson
	 *            the input json
	 * @return the download item
	 */
	public static DownloadItem newObjectfromJSON(final String inputJson) {
		Gson g = new Gson();
		DownloadItem instance = g.fromJson(inputJson, DownloadItem.class);
		return instance;
	}

	public String toJSON() {
		return new Gson().toJson(this).replace("\\u003d", "=").replace("\\u0026", "&");
	}

	/**
	 * Gets the id item metadata.
	 * 
	 * @return the id item metadata
	 */
	public String getIdItemMetadata() {
		return idItemMetadata;
	}

	/**
	 * Sets the id item metadata.
	 * 
	 * @param idItemMetadata
	 *            the new id item metadata
	 */
	public void setIdItemMetadata(final String idItemMetadata) {
		this.idItemMetadata = idItemMetadata;
	}

	/**
	 * Gets the url.
	 * 
	 * @return the url
	 */
	public String getUrl() {
		if (Url == null) return null;
		return Url.replace("\\u003d", "=").replace("\\u0026", "&");
	}

	/**
	 * Sets the url.
	 * 
	 * @param url
	 *            the new url
	 */
	public void setUrl(final String url) {
		if (url == null) {
			Url = null;
		} else {
			Url = url.replace("\\u003d", "=").replace("\\u0026", "&");
		}
	}

	/**
	 * @return the originalUrl
	 */
	public String getOriginalUrl() {
		if (originalUrl == null) return null;
		return originalUrl.replace("\\u003d", "=").replace("\\u0026", "&");
	}

	/**
	 * @param originalUrl
	 *            the originalUrl to set
	 */
	public void setOriginalUrl(final String originalUrl) {
		if (originalUrl == null) {
			this.originalUrl = null;
		} else {
			this.originalUrl = originalUrl.replace("\\u003d", "=").replace("\\u0026", "&");
		}
	}

	/**
	 * Gets the file name.
	 * 
	 * @return the file name
	 */
	public String getFileName() {
		if ((fileName == null) || "".equals(fileName)) return getIdItemMetadata() + "::" + Hashing.md5(getOriginalUrl());
		return fileName;
	}

	/**
	 * Sets the file name.
	 * 
	 * @param fileName
	 *            the new file name
	 */
	public void setFileName(final String fileName) {
		this.fileName = fileName;
	}
}
