package eu.dnetlib.data.download.rmi;

/**
 * The DownloadPluin should retrieve the correct URL of the file to download
 */
public interface DownloadPlugin {

	/**
	 * This method retrieve the correct Url of the file from the starting URL
	 * 
	 * @param url
	 *            the starting url
	 * @return the Url of the correct file
	 */
	DownloadItem retrieveUrl(DownloadItem item);

	/**
	 * This method retrieve the correct Url of the file from a list of starting URL
	 * 
	 * @param urls
	 *            the list of starting url
	 * @return the list of the file URL
	 */
	Iterable<DownloadItem> retireveUrls(Iterable<DownloadItem> items);

	/**
	 * Get the name of the plugin
	 * 
	 * @return the name of the plugin
	 */
	String getPluginName();

}
