/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.data.download.worker;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import eu.dnetlib.data.download.DownloadReport;
import eu.dnetlib.data.download.DownloadReportMap;
import eu.dnetlib.data.download.DownloadServiceImpl;
import eu.dnetlib.data.download.rmi.DownloadItem;
import eu.dnetlib.data.objectstore.modular.ObjectStoreRecord;
import eu.dnetlib.data.objectstore.modular.connector.ObjectStore;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreFile;
import eu.dnetlib.data.objectstore.rmi.ObjectStoreServiceException;
import eu.dnetlib.data.objectstore.rmi.Protocols;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DownloadWorker
implements Callable<DownloadReportMap> {
    private static final Log log = LogFactory.getLog(DownloadWorker.class);
    private BlockingQueue<String> queue = null;
    private ObjectStore objectStore = null;
    private Protocols protocol;
    private String mimeType;
    private Function<String, DownloadItem> converter;

    public DownloadWorker(BlockingQueue<String> queue, ObjectStore objectStore, Protocols protocol, String mimeType, Function<String, DownloadItem> converter) {
        this.setConverter(converter);
        this.setQueue(queue);
        this.setObjectStore(objectStore);
        this.setMimeType(mimeType);
        this.setProtocol(protocol);
    }

    @Override
    public DownloadReportMap call() throws Exception {
        DownloadReportMap report = new DownloadReportMap();
        try {
            String takedObject = this.queue.take();
            DownloadItem di = (DownloadItem)this.getConverter().apply((Object)takedObject);
            if (log.isDebugEnabled()) {
                log.debug((Object)takedObject);
            }
            while (DownloadServiceImpl.END_QUEUE != di) {
                log.debug((Object)(Thread.currentThread().getId() + ": Reading  " + takedObject));
                if (di == null) {
                    log.info((Object)"the current download item is Null, skipping");
                }
                if (di != null && di.getUrl() != null && di.getUrl().length() != 0 && !this.checkIfExists(di)) {
                    try {
                        URL toDownload = this.followURL(new URL(di.getUrl()), report, di);
                        ObjectStoreRecord record = new ObjectStoreRecord();
                        ObjectStoreFile metadata = new ObjectStoreFile();
                        metadata.setObjectID(di.getFileName());
                        metadata.setMetadataRelatedID(di.getIdItemMetadata());
                        metadata.setAccessProtocol(this.protocol);
                        metadata.setMimeType(this.mimeType);
                        metadata.setDownloadedURL(di.getOriginalUrl());
                        record.setFileMetadata(metadata);
                        record.setInputStream(toDownload.openStream());
                        this.objectStore.feedObjectRecord(record);
                        report.addDowload();
                        log.debug((Object)("Saved object " + metadata.toJSON()));
                    }
                    catch (Throwable e) {
                        log.error((Object)"An error occur inside the loop: ", e);
                    }
                }
                takedObject = this.queue.take();
                log.debug((Object)(Thread.currentThread().getId() + ": Next Object From Queue  " + takedObject));
                di = (DownloadItem)this.getConverter().apply((Object)takedObject);
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)takedObject);
            }
            this.queue.put("END_DOWNLOAD");
        }
        catch (Exception e) {
            log.error((Object)("An error occured : " + Joiner.on((String)"\tat ").join((Object[])e.getStackTrace())));
            report.setStatus(false);
            return report;
        }
        log.info((Object)("CLOSED THREAD " + Thread.currentThread().getId()));
        report.setStatus(true);
        return report;
    }

    private void reportException(DownloadReportMap report, DownloadItem di, Exception e) {
        String className = e.getClass().getName();
        if (!report.containsKey(className)) {
            DownloadReport dr = new DownloadReport();
            dr.setStackTrace(Joiner.on((String)"\tat ").join((Object[])e.getStackTrace()));
            dr.setRecordId(di.getIdItemMetadata());
            report.put(className, dr);
        } else {
            ((DownloadReport)report.get(className)).incrementError();
        }
    }

    private URL followURL(URL inputURL, DownloadReportMap report, DownloadItem di) throws IOException {
        String ptrcl = inputURL.getProtocol();
        if (ptrcl.startsWith("file")) {
            log.debug((Object)("the protocol is File, returning " + inputURL));
            return inputURL;
        }
        HttpURLConnection conn = (HttpURLConnection)inputURL.openConnection();
        conn.setInstanceFollowRedirects(true);
        HttpURLConnection.setFollowRedirects(true);
        String location = inputURL.toString();
        if (conn.getResponseCode() >= 300 && conn.getResponseCode() < 400) {
            location = conn.getHeaderFields().get("Location").get(0);
            conn.disconnect();
        }
        if (!location.equals(inputURL.toString())) {
            return new URL(location);
        }
        return inputURL;
    }

    private boolean checkIfExists(DownloadItem di) {
        try {
            return this.objectStore.deliverObject(di.getFileName()) != null;
        }
        catch (ObjectStoreServiceException e) {
            log.debug((Object)e.getMessage());
            return false;
        }
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    public void setQueue(BlockingQueue<String> queue) {
        this.queue = queue;
    }

    public void setProtocol(Protocols protocol) {
        this.protocol = protocol;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Function<String, DownloadItem> getConverter() {
        return this.converter;
    }

    public void setConverter(Function<String, DownloadItem> converter) {
        this.converter = converter;
    }
}

